import Ember from 'ember';

const CC_LICENCE_URL_REGEXP = /http:\/\/creativecommons\.org\/licenses\/([byndsac-]+)\/([\d\.]+)\//;
const CC_LICENCE_TEXT = {
  'by': 'Attribution',
  'by-nd': 'Attribution - Pas de Modification',
  'by-sa': 'Attribution - Partage dans les Mêmes Conditions',
  'by-nc': 'Attribution - Pas d’Utilisation Commerciale',
  'by-nc-nd': 'Attribution - Pas d\'Utilisation Commerciale - Pas de Modification',
  'by-nc-sa': 'Attribution - Pas d\'Utilisation Commerciale - Partage dans les Mêmes Conditions'
};

export default Ember.Component.extend({
  tagName: 'span',
  code: Ember.computed('matches', function() {
    return this.get('matches')[1];
  }),
  version: Ember.computed('matches', function() {
    return this.get('matches')[2];
  }),
  matches: Ember.computed('url', function() {
    const url = this.get('url');
    if(!url) {
      return [url,'by', '4.0'];
    }
    let m = url.match(CC_LICENCE_URL_REGEXP);
    if(m === null || m.length !== 3) {
      return [url,'by', '4.0'];
    }
    return m;
  }),
  text: Ember.computed('code', function() {
    const code = this.get('code');
    return CC_LICENCE_TEXT[code];
  })

});
