<?php

namespace CorpusParole\Console\Commands;

use Illuminate\Console\Command;

use CorpusParole\Libraries\Handle\handleClient;

class ManageHandle extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $signature = 'corpus-parole:manageHandle
                                {--r|replace: Replace value for existing handles}
                                {--k|key=: Private key}
                                {--p|password=: key password}
                                {--P|ask-password: ask for private key password}
                                {--step-size=100 : number of documents to retrieve from repository at a time before indexing}';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Synchronize the handle registry with the content of the rdf repository.';


    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct(DocumentRepository $documentRepository)
    {
        $this->documentRepository = $documentRepository;
        parent::__construct();
    }

    private function registerHandle($doc) {

    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $stepSize = $this->option('step-size');

        $passwordKey = $this->option('password');
        if($this->option('ask-password')) {
            $password = $this->secret('Private key password?');
        }

        $privateKey = $this->option('key');

        $privateKeyRes = openssl_pkey_get_private($privateKey, $password);


        // create handle client
        $this->handleClient = new HandleClient($privateKeyRes);

        $this->info('Adding documents handles...');

        $lastPage = $this->documentRepository->paginateAll($stepSize, 'page')->lastPage();
        $total = $this->documentRepository->getCount();

        $progressBar = $this->output->createProgressBar($total);
        $progressBar->setFormat(' %current%/%max% [%bar%] %percent:3s%% - %message%');

        for ($page=1;$page<=$lastPage;$page++)
        {
            $docs = $this->documentRepository->paginateAll($stepSize, 'page', $page);
            foreach ($docs as $doc){
                $this->registerHandle($doc);
                $progressBar->setMessage($doc->getId());
                $progressBar->advance();
            }
        }
        $progressBar->finish();
        $this->info('Adding handles completed');

        $this->info('Removing extra handles...');

        $lastPage = -1;
        $page = 0;
        $lastPage = 0;

        while($lastPage<0 || $page <= $lastPage) {
            $handle_res = $this->handleClient->paginateAll($stepSize, 'page', $page++);
            foreach($handle_res as $handle) {
                if(is_null($this->documentRepository->get($handle))) {
                    $this->handleClient->deleteHandle($handle);
                }
                $progressBar->setMessage($handle);
                $progressBar->advance();
            }
        }

        $this->info('Removing extra handles completed');


        // query ids
        // loop on ids
        // PUT handle
        // query handle
        // if not in rdf ids delete

        // delete handle session
    }
}
