import store from 'store';
import * as constants from 'corpus-common-addon/utils/constants';

export default {
    set: function(key, val, exp) {
        var expiration = exp;
        if(typeof exp === 'undefined') {
          expiration = constants.DEFAULT_STORE_EXP;
        }
        store.set(key, { val:val, exp:expiration, time:new Date().getTime() });
        return val;
    },
    get: function(key) {
        var info = store.get(key)
        if (!info) { return null }
        if (new Date().getTime() - info.time > info.exp) { return null }
        return info.val
    }
}
