import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue', 'discours', 'date', 'thematique'],
  location: null,
  langue: null,
  discours: null,
  date: null,
  thematique: null,
  currentItem: {title: "example", master: 'http://www.noiseaddicts.com/samples_1w72b820/3921.mp3'},
  filteredSounds: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var discours = this.get('discours');
    var date = this.get('date');
    // var thematique = this.get('thematique');

    var sounds = this.get('model');

    if (location) {
      sounds = sounds.filterBy('spatial', location);
    }
    if (langue) {
      sounds = sounds.filterBy('language', langue);
    }
    if (discours) {
      sounds = sounds.filterBy('type', discours);
    }
    if (date) {
      sounds = sounds.filterBy('created', parseInt(date));
    }
    // if (thematique) {
    //   sounds = sounds.filterBy('thematique', thematique);
    // }

    return sounds;
  }),
  actions: {
    deleteTag: function(query){
      var queryParams = {};
      queryParams[query]  = null;
      this.transitionToRoute({queryParams: queryParams});
    },
    play: function(item){
      this.set("currentItem", item);
      $("#audio-player").load();
      $(".result-item").toggleClass("playing", false);
      $("#"+item.id).toggleClass("playing", true);
    },
    details: function(item){
      if ($("#"+item.id).hasClass("details")){
          $("#"+item.id).toggleClass("details", false);
      } else{
        $(".result-item").toggleClass("details", false);
        $("#"+item.id).toggleClass("details", true);
      }
    }
  }
});
