<?php
namespace CorpusParole\Models;

use CorpusParole\Libraries\RdfModel\RdfModelResource;
use CorpusParole\Libraries\Utils;
use JsonSerializable;
use Log;

/**
 */
class GeoResource extends RdfModelResource implements JsonSerializable {

    public function __construct($uri, $graph) {
        parent::__construct($uri, $graph);
    }

    private $refLoc = false;
    private $notes = null;

    public function clearMemoizationCache() {
        $this->refLoc = false;
        $this->notes = null;
    }

    public function getRefLoc() {
        if($this->refLoc === false) {
            $refLoc = $this->getResource("<http://www.w3.org/2002/07/owl#sameAs>");
            $this->refLoc = is_null($refLoc)?null:$refLoc->getUri();
        }
        return $this->refLoc;
    }

    public function getNotes() {
        if(is_null($this->notes)) {
            $this->notes = $this->all('<http://www.w3.org/2004/02/skos/core#note>');
        }
        return $this->notes;
    }

    public function jsonSerialize() {
        $notes = array_map(
            function($note) { return Utils::processLiteralResourceOrString($note); },
            $this->getNotes()
        );
        return [
            'ref-loc' => $this->getRefLoc(),
            'notes' => $notes
        ];
    }

}