import ENV from 'app-client/config/environment';
import _ from 'lodash/lodash';
import * as constants from 'corpus-common-addon/utils/constants';

export default function() {

    // These comments are here to help you get started. Feel free to delete them.

    /*
      Config (with defaults).

      Note: these only affect routes defined *after* them!
    */
    // this.urlPrefix = '';    // make this `http://localhost:8080`, for example, if your API is on a different server
    // this.namespace = '';    // make this `api`, for example, if your API is namespaced
    this.namespace = ENV.baseURL.replace(/\/$/,'')+'/api/v1';
    // this.timing = 400;      // delay for each request, automatically set to 0 during testing

    this.get('/documents');
    this.get('/documents/:id', function(db, request) {
        var docId = decodeURIComponent(request.params.id);

        return {
            'document': db.details_documents.find(docId)
        };
    });

    this.get('/documents/:id/transcript', function(db, request) {
        var docId = decodeURIComponent(request.params.id);

        return db.transcripts.find(docId).transcript;
    });


    this.get('/languages', function(db) {
        var res = {};
        _.each(db.languages, function(lang) {
            res[lang.id] = lang.count;
        });
        return res;
    });

    this.get('/themes', function(db) {
        var res = {};
        _.each(db.themes, function(theme) {
            res[theme.id] = {'label': theme.label, 'count': theme.count};
        });
        return res;
    });

    this.get('/discourses', function(db) {
        var res = {};
        _.each(db.discourses, function(discourse) {
            res[discourse.id] = {'label': discourse.label, 'count': discourse.count};
        });
        return res;
    });

    this.get('/lexvo/:ids', function(db, request) {
        var langIds = decodeURIComponent(request.params.ids);
        var resMap = _.reduce(langIds.split(','), function(res, id) {
            var fullId = id;
            if(!_.startsWith(fullId, constants.LEXVO_BASE_URL)) {
                fullId = constants.LEXVO_BASE_URL + id;
            }
            var lexvoRes = db.lexvo.find(fullId);
            res[id] = lexvoRes?lexvoRes.name:null;
            return res;
        }, {});

        return {
            'lexvoids': resMap
        };

    });

    this.get('/bnf/:ids', function(db, request) {

        var bnfIds = decodeURIComponent(request.params.ids);
        var resMap = _.reduce(bnfIds.split(','), function(res, id) {
            var fullId = id;
            if(_.startsWith(fullId, constants.BNF_BASE_URL)) {
                fullId = fullId.slice(constants.BNF_BASE_URL.length);
            } else if (_.startsWith(fullId, constants.BNF_ARK_BASE_URL)) {
                fullId = fullId.slice(constants.BNF_ARK_BASE_URL.length);
            } else if (!_.startsWith(fullId, constants.BNF_ARK_BASE_ID)) {
                fullId = constants.BNF_ARK_BASE_ID + fullId;
            }
            var bnfRes = db.lexvo.find(fullId);
            res[fullId] = bnfRes?bnfRes.label:null;
            return res;
        }, {});

        return {
            'bnfids': resMap
        };

    });

    /*
      Route shorthand cheatsheet
    */
    /*
      GET shorthands

      // Collections
      this.get('/contacts');
      this.get('/contacts', 'users');
      this.get('/contacts', ['contacts', 'addresses']);

      // Single objects
      this.get('/contacts/:id');
      this.get('/contacts/:id', 'user');
      this.get('/contacts/:id', ['contact', 'addresses']);
    */

    /*
      POST shorthands

      this.post('/contacts');
      this.post('/contacts', 'user'); // specify the type of resource to be created
    */

    /*
      PUT shorthands

      this.put('/contacts/:id');
      this.put('/contacts/:id', 'user'); // specify the type of resource to be updated
    */

    /*
      DELETE shorthands

      this.del('/contacts/:id');
      this.del('/contacts/:id', 'user'); // specify the type of resource to be deleted

      // Single object + related resources. Make sure parent resource is first.
      this.del('/contacts/:id', ['contact', 'addresses']);
    */

    /*
      Function fallback. Manipulate data in the db via

      - db.{collection}
      - db.{collection}.find(id)
      - db.{collection}.where(query)
      - db.{collection}.update(target, attrs)
      - db.{collection}.remove(target)

      // Example: return a single object with related models
      this.get('/contacts/:id', function(db, request) {
      var contactId = +request.params.id;

      return {
      contact: db.contacts.find(contactId),
      addresses: db.addresses.where({contact_id: contactId})
      };
      });

    */
}

/*
  You can optionally export a config that is only loaded during tests
  export function testConfig() {

  }
*/
