// mirage/serializers/blog-post.js
import BaseSerializer from './application';
import _ from 'lodash';

export default BaseSerializer.extend({
    attrs: ['id', 'title', 'language', 'url', 'issued', 'modified', 'publishers', 'mediaArray', 'transcript'],

    serialize(response, request) {

        console.log(request, response);
        // This is how to call super, as Mirage borrows [Backbone's implementation of extend](http://backbonejs.org/#Model-extend)
        let json = BaseSerializer.prototype.serialize.apply(this, arguments);

        json['documents'] = _.map(json['documents'], function(doc) {
            let res = _.omit(doc, ['publishers', 'mediaArray', 'transcript']);
            res['publisher'] = doc['publishers'].join(', ');
            res['duration_ms'] = doc['mediaArray']?doc['mediaArray'][_(Object.keys(doc['mediaArray'])).first()]['extent_ms']:0;
            res['transcript_url'] = (doc['transcript'] && doc['transcript']['url'])?doc['transcript']['url']:null;
            return res;
        });

        return json;
    }

});
