import Ember from 'ember';
import CellEditingMixin from 'bo-client/mixins/cell-editing-mixin';

export default Ember.Component.extend(CellEditingMixin, {
  tagName: "tr",
  actions: {
    removeContributor: function(contributor) {
      console.log("REMOVE CONTRIBUTOR", contributor);
      this.get('removeContributor')(contributor);
    },
    saveContributor: function(contributor, index) {
      this.get('saveContributor')(contributor, index);
      this.set('isEditing', false);
    },
    valueChanged: function() {
      this.$(".bo-doc-edit-icons-save").addClass("bo-doc-edit-icons-save-dirty bo-doc-edit-icons");
    }
  },
  click: undefined,
  _setupClickListener: Ember.on('didInsertElement', function() {
    this._super(...arguments);
    if(!this.get('isEditing')) {
      this.$('.bo-doc-contrib-edit').click(Ember.run.bind(this,() => {
        var _this = this;
        setTimeout(() => {
          _this.set('isEditing', true);
        }, 200);
      }));
    }
  }),

});
