#!/usr/bin/env bash

pushd /vagrant/root/var/www/corpusdelaparole/corpus/
echo "---> Launching composer"
php composer.phar install --ignore-platform-reqs -o
echo "---> Composer done"
popd

pushd /vagrant
echo "---> Launching packaging"
rm -f *.rpm
#TODO: read version from corpus
version=$(grep -oP "\'version\'\s*=>\s*\'\K[\.0-9]+(?=\')" /vagrant/root/var/www/corpusdelaparole/corpus/config/version.php)
version=${version:-0.0.0}

fpm \
    --verbose \
    -a all \
    -s dir \
    -t rpm \
    -C /vagrant/root \
    -d httpd \
    -d php56 \
    -d mariadb-server \
    --name corpusdelaparole \
    --version "$version" \
    --iteration $(date +%s) \
    --description "Corpus de la parole source rpm" \
    --url "http://corpusdelaparole.huma-num.fr" \
    --rpm-user apache \
    --rpm-group apache \
    --directories /var/www/corpusdelaparole \
    --after-install /vagrant/post_install.sh \
    --after-remove /vagrant/post_uninstall.sh \
    --after-upgrade /vagrant/post_upgrade.sh \
    .
echo "---> Packaging done."
popd
