<?php

namespace CorpusParole\Http\Controllers\Api;

use Illuminate\Http\Request;
use Log;
use Es;

use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Libraries\Filters\CorpusFilterManager;


class DateStatsController extends Controller
{
    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {


        $filterManager = new CorpusFilterManager();
        $filters = $filterManager->prepareFilters($request);
        unset($filters['dates']);
        $qFilterParts = $filterManager->buildESFilters($filters);

        $query = $filterManager->buildQuery($qFilterParts);

        $esQuery = [
            'index' => config('elasticsearch.index'),
            'body' => [
                "size" => 0,
                "query" => $query,
                "aggs" => [
                    "datestats" => [
                        "nested"=> [
                            "path" => "creation_years"
                        ],
                        "aggs" => [
                            "years" => [
                                "terms"=> [
                                    "field" => "creation_years.year",
                                    "size" => 2147483647,
                                    "order" => [
                                        "_term" => "asc"
                                    ]
                                ],
                                "aggs" => [
                                    "year_count" => [
                                        "sum" => [
                                            "field" => "creation_years.weight"
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];
        $esRes = Es::search($esQuery);

        $datestats = [];

        foreach($esRes['aggregations']['datestats']['years']['buckets'] as $bucket) {
            $c = round($bucket['year_count']['value']);
            if($c > 0) {
                $datestats[(string)($bucket['key'])] = $c;
            }
        }

        return response()->json(['datestats' => $datestats ]);
    }

}
