import Ember from 'ember';
import _ from 'lodash/lodash';
import RSVP from 'rsvp';
import ENV from 'app-client/config/environment';
import URI from 'urijs';

export default Ember.Route.extend({

    filter: Ember.inject.service(),
    constants: Ember.inject.service(),

    model: function(params) {
        let filterQueryArgs = _.clone(this.get('filter').get('queryParamsValues'));
        return this.store.query('document', _.merge(filterQueryArgs, {
            page: params['page'],
            perpage: this.get('constants').DOCUMENTS_PAGINATION_PERPAGE
        }));
    },

    /**
      Serializes value of the query parameter based on defaultValueType
      @method serializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */
    serializeQueryParam(value, urlKey, defaultValueType) {
        if(_.contains(this.get('filter').get('queryParams'), urlKey)) {
            return this.get('filter').serializeQueryParam(value, urlKey, defaultValueType);
        }
        return this._super(value, urlKey, defaultValueType);
    },

    /**
      Deserializes value of the query parameter based on defaultValueType
      @method deserializeQueryParam
      @param {Object} value
      @param {String} urlKey
      @param {String} defaultValueType
      @private
    */
    deserializeQueryParam(value, urlKey, defaultValueType) {
        if(_.contains(this.get('filter').get('queryParams'), urlKey)) {
            return this.get('filter').deserializeQueryParam(value, urlKey, defaultValueType);
        }
        return this._super(value, urlKey, defaultValueType);
    },

    beforeModel: function(transition) {
        new RSVP.Promise((resolve) => {
          // succeed
          this.get('filter').setProperties(transition['queryParams']);
          resolve();
        });
        return this._super(...arguments);
    },

    queryParams: Ember.computed('filter', function() {
        var res = this.get('filter').getRouteQueryParams();
        res['page'] = { refreshModel: true };
        res['notice'] = { refreshModel: false };
        return res;
    }),

    actions: {
        loading(transition) {
          let controller = this.controllerFor('application');
          controller.set('isLoading', true);
          transition.promise.finally(function() {
              controller.set('isLoading', false);
          });
        },

        didTransition: function() {
            // Append body classname depending on the route
            Ember.$('body').removeClass((this.controller.get('currentPath') || '').replace(/\//g, '-').dasherize());
            Ember.run.once(this, function() {
                Ember.$('body').addClass((this.controller.get('currentPath') ||'').replace(/\//g, '-').dasherize());
            });
            // change external navigations links
            if(ENV.APP.navigationLinksSelector) {
                return new RSVP.Promise((resolve) => {
                  setTimeout(() => {
                    let hash = window.location.hash;
                    if(!hash) {
                        return true;
                    }
                    let uriHash = URI(hash.substr(1));
                    Ember.$(ENV.APP.navigationLinksSelector).each((i, l) => {
                        let uri = URI(Ember.$(l).prop('href'));
                        if(uri.fragment()) {
                          let urifragment = URI(uri.fragment()).search(uriHash.search());
                          Ember.$(l).prop('href', uri.fragment(urifragment.href()).href());
                        }
                    });
                    resolve(true);
                  }, 10);
                });
            }
            return true;
        }

    }

});
