import Ember from 'ember';
import * as constants from 'corpus-common-addon/utils/constants';
import layout from '../templates/components/doc-language';

export default Ember.Component.extend({
    layout: layout,
    tagName: "span",

    lexvoResolver: Ember.inject.service(),

    _resolveLexvoIds: Ember.on('init', Ember.observer('url', function() {
      this.get('lexvoResolver').getName(this.get('url')).then(function(str) {
        if (!(this.get('isDestroyed') || this.get('isDestroying'))) {
          this.set('resolvedName', str);
        }
      }.bind(this));
    })),

    code: Ember.computed('url', function() {
      var rawLanguage = this.get('url');
      if(rawLanguage && rawLanguage.startsWith(constants.LEXVO_BASE_URL) ) {
        return rawLanguage.substr(constants.LEXVO_BASE_URL.length);
      }
      return rawLanguage;
    }),
    isLanguageLink: Ember.computed.match('url', /^http\:\/\//)

});
