import Ember from 'ember';

export function annotationContent(params/*, hash*/) {
  if(!params || (params.length === 0)) {
    return "";
  }

  let content = params[0];
  if(typeof content === "string") {
    return content;
  } else if(typeof content === "object") {
    let res = `[ ${content.ctype}`;
    for(let k in content) {
      if(k !== 'ctype') {
        res += `, ${k}: ${content[k]}`;
      }
    }
    return res + " ]";
  } else {
    return content;
  }
}

export default Ember.Helper.helper(annotationContent);
