<?php
namespace CorpusParole\Libraries\Mappers;

use Config;

use CorpusParole\Libraries\Utils;
use CorpusParole\Libraries\CocoonUtils;

use EasyRdf\Graph;
use EasyRdf\Literal;
use EasyRdf\Resource;


/**
 *
 * rdf:type
 * sesame:directType
 ** <http://purl.org/dc/elements/1.1/description> -> providedCHO
 * <http://purl.org/dc/elements/1.1/format> -> webRepresentation
 * <http://purl.org/dc/elements/1.1/language> -> providedCHO
 * <http://purl.org/dc/elements/1.1/publisher> -> providedCHO
 * <http://purl.org/dc/elements/1.1/rights> -> providedCHO
 * <http://purl.org/dc/elements/1.1/subject> -> providedCHO
 * <http://purl.org/dc/elements/1.1/title> -> providedCHO
 * <http://purl.org/dc/elements/1.1/type> -> providedCHO
 * <http://purl.org/dc/terms/accessRights> -> providedCHO
 * <http://purl.org/dc/terms/available> -> providedCHO
 * <http://purl.org/dc/terms/conformsTo> -> for text -> webRepresentation (2 val : http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_transcriber : transcript, http://purl.org/poi/crdo.vjf.cnrs.fr/crdo-dtd_archive)
 * <http://purl.org/dc/terms/created> -> providedCHO
 * <http://purl.org/dc/terms/isFormatOf> -> webResource
 *** <http://purl.org/dc/terms/isPartOf> ->collections
 * <http://purl.org/dc/terms/issued> -> providedCHO
 * <http://purl.org/dc/terms/license> -> providedCHO
 *** <http://purl.org/dc/terms/requires> -> transcriptions
 * <http://www.language-archives.org/OLAC/1.1/data_inputter> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/depositor> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/editor> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/interviewer> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/researcher> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/speaker> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/transcriber> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/participant> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/compiler> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/interpreter> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/author> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/translator> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/signer> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/recorder> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/responder> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/developer> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/sponsor> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/annotator> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/singer> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/consultant> -> providedCHO
 * <http://www.language-archives.org/OLAC/1.1/research_participant> -> providedCHO
 * <http://crdo.risc.cnrs.fr/schemas/master> -> webRepresentation
 * <http://purl.org/dc/terms/extent> -> webRepresentation
 * <http://purl.org/dc/terms/isRequiredBy> -> transcriptions
 * <http://purl.org/dc/terms/spatial> -> edm:Place
 * <http://www.w3.org/2003/01/geo/wgs84_pos#lat> -> edm:Place
 * <http://www.w3.org/2003/01/geo/wgs84_pos#long> -> edm:Place
 * <http://purl.org/dc/elements/1.1/source> -> providedCHO
 * <http://purl.org/dc/terms/tableOfContents> -> providedCHO
 * <http://purl.org/dc/terms/alternative> -> providedCHO
 * <http://purl.org/dc/terms/modified> -> providedCHO
 * <http://purl.org/dc/terms/abstract> -> providedCHO
 * <http://purl.org/dc/elements/1.1/identifier> -> providedCHO but question...
 * <http://purl.org/dc/terms/medium> -> providedCHO
 * <http://purl.org/dc/elements/1.1/coverage> -> providedCHO
 * <http://purl.org/dc/elements/1.1/relation> - providedCHO
 * <http://purl.org/dc/terms/description> -> ProvidedCHO
 * <http://purl.org/dc/terms/bibliographicCitation> -> providedCHO
 * <http://purl.org/dc/elements/1.1/creator> -> providedCHO
 * <http://purl.org/dc/terms/references> -> providedCHO
 * <http://purl.org/dc/elements/1.1/reference> -> providedCHO
 *
 * pour olac : http://quijote.fdi.ucm.es:8084/LLOD-LSASummerWorkshop2015/Presentations/Simons--OLAC%20Metadata.pdf
 * DATA consolidation
 * -> edm:place : get label + altLabel
 */
class CocoonSoundRdfMapper extends CocoonContentRdfMapper {

    protected function getResourceBaseId($res=null) {

        if(is_null($res)) {
            $res = $this->inputGraph->resource($this->uri);
        }
        return $res->getUri();
    }

    /**
     * Build teh webresources
     */
    protected function mapWebResources($res, $outputGraph) {

        $resId = CocoonUtils::getIdFromUri($res->getUri());
        $resUri = CocoonUtils::getCorpusUriFromId($resId);


        $aggregationNode = $outputGraph->resource($resUri, 'ore:Aggregation');

        // get extent
        $extent = $res->get($this->inputGraph->resource('http://purl.org/dc/terms/extent'));

        // build master webresources
        $masterReprUrl = $res->get($this->inputGraph->resource('http://crdo.risc.cnrs.fr/schemas/master'));
        if(! is_null($masterReprUrl)) {
            $masterWebResource = $outputGraph->resource($masterReprUrl, 'edm:WebResources');
            if(!is_null($extent)) {
                $masterWebResource->addLiteral($outputGraph->resource('http://purl.org/dc/terms/extent'),$extent);
            }
            $formatAdded = false;
            foreach($res->all($this->inputGraph->resource('http://purl.org/dc/elements/1.1/format')) as $wrformat) {
                $masterWebResource->addLiteral('http://purl.org/dc/elements/1.1/format', $wrformat);
                $formatAdded = true;
            }
            if(!$formatAdded) {
                $mimetype = Utils::getMimetype($masterReprUrl);
                $masterWebResource->addLiteral('http://purl.org/dc/elements/1.1/format', Literal::create($mimetype, null, $outputGraph->resource('http://purl.org/dc/terms/IMT')));
            }

            $this->addDateToWebResource($res, $masterWebResource);

        }

        // build others
        foreach($res->all($this->inputGraph->resource('http://purl.org/dc/terms/isFormatOf')) as $reprUrl) {
            $webResource = $outputGraph->resource($reprUrl, 'edm:WebResources');
            if(!is_null($extent)) {
                $webResource->addLiteral($outputGraph->resource('http://purl.org/dc/terms/extent'),$extent);
            }
            $mimetype = Utils::getMimetype($reprUrl);
            $webResource->addLiteral('http://purl.org/dc/elements/1.1/format', Literal::create($mimetype, null, $outputGraph->resource('http://purl.org/dc/terms/IMT')));

            if(!is_null($masterReprUrl)) {
                $webResource->addResource('edm:isDerivativeOf', $masterReprUrl);
            }
            $this->addDateToWebResource($res, $webResource);
            $aggregationNode->addResource('edm:hasView', $reprUrl);
        }
    }
}
