<?php

use CorpusParole\Repositories\DocumentRepository;
use Mockery as m;

/**
 *
 */
class DocumentListControllerTest extends TestCase {

    private $documentRepository;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->documentRepository = m::mock('CorpusParole\Repositories\DocumentRepository');
        $this->app->instance('CorpusParole\Repositories\DocumentRepository', $this->documentRepository);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testIndex() {
        $this->documentRepository->shouldReceive('all')->once()->andReturn(array());

        $response = $this->call('GET', '/bo/docs');

        $this->assertResponseOk($response);
        $this->assertViewHas('docs');
    }
}
