<?php

namespace CorpusParole\Repositories;

use Config;
use Log;
use CorpusParole\Models\Document;

/**
 * Implement the DocumentRepository using EasyRdf
 */
class RdfDocumentRepository implements DocumentRepository {

    private $sparqlClient;

    function __construct() {
        $this->sparqlClient = new \EasyRdf_Sparql_Client(Config::get('corpusparole.sesame_query_url'), Config::get('corpusparole.sesame_update_url'));
    }

    public function all() {

        $docs = $this->sparqlClient->query(
            'SELECT * WHERE {'.
            '    ?uri <http://xmlns.com/foaf/0.1/primaryTopic> ?b;'.
            '} ORDER BY ?uri'
        );

        $data = [];

        foreach ($docs as $doc) {
            array_push($data, new Document($doc->uri->getUri()));
        }

        return $data;
    }

    public function get($id) {

        $doc_uri = Config::get('corpusparole.cocoon_doc_id_base_uri').$id;

        //$doc = $sparql->query(
        //	"CONSTRUCT {".
        //	"    ?doc ?p ?v.".
        //	"}".
        //	"WHERE {".
        //	"    <$doc_uri> <http://xmlns.com/foaf/0.1/primaryTopic> ?doc.".
        //	"    ?doc ?p ?v;".
        //	"}"
        //);

        // We want the CBD (Concise Bounded Description, cf. http://www.w3.org/Submission/CBD/)
        // WARNING: This seems to work in sesame for our dataset.
        $doc = $this->sparqlClient->query(
            'DESCRIBE ?doc '.
            'WHERE {'.
            "    <$doc_uri> <http://xmlns.com/foaf/0.1/primaryTopic> ?doc;".
            '}'
        );

        return new Document($doc_uri, $doc);

    }

}
