<?php

namespace CorpusParole\Http\Controllers\Bo;

use Config;
use Log;

use CorpusParole\Http\Controllers\Controller;
use CorpusParole\Repositories\DocumentRepository;

use Illuminate\Http\Request;

class DocumentListController extends Controller {

    /**
     * Create a new controller instance.
     */
    public function __construct(DocumentRepository $documentRepo) {
        $this->documentRepository = $documentRepo;
    }

    /**
     * Display a listing of the resource.
     *
     * @return Response
     */
    public function index() {
        return view('bo.docList', ['docs' => $this->documentRepository->all()]);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Response
     */
    public function store()
    {
        //
    }

    /**
     * Display the specified resource.
     *
     * @param string $id
     *
     * @return Response
     */
    public function show($id)
    {
        //$doc->add("<$doc_uri>");
        $doc = $this->documentRepository->get($id);

        return view('bo.docDetail', ['doc' => $doc]);

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param int $id
     *
     * @return Response
     */
    public function edit($id)
    {
        $doc = $this->documentRepository->get($id);

        return view('bo.docEdit', ['doc' => $doc]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param int $id
     *
     * @return Response
     */
    public function update($id, Request $request)
    {
        Log::debug('REQUEST : '.print_r($request->input(), true));

        $doc = $this->documentRepository->get($id);

        $newDoc = clone $doc;

        $newDoc->updateDiscourseTypes(array_unique($request->input('discourse_type')));

        Log::debug("Graph isomorphes ? " . print_r(\EasyRdf_Isomorphic::bijectionBetween($doc->getGraph(), $doc->getGraph()), true));

        //TODO: save change in store
        //TODO: create log object

        return redirect()->route('bo.docs.show', ['id' => $id]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param int $id
     *
     * @return Response
     */
    public function destroy($id)
    {
        //
    }
}
