import JSONAPISerializer from 'ember-data/serializers/json-api';

export default JSONAPISerializer.extend({

	normalizeResponse: function(store, primaryModelClass, payload, id, requestType) {
		var annotations = [];
		payload.annotations.forEach(function(annotation) {
			annotations.push({
				'content': annotation.content.data.content,
				'translation': annotation.content.data.transl['@value'],
				'start': annotation.begin,
				'end': annotation.end
			});
		});
        return {
            'data': {
	            'id': id,
	            'type': 'transcript',
	            'attributes': {
	                'title': payload.meta['dc:title']['@value'],
	                'annotations': annotations
	            }
	        }
        };
	}

});
