import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['transcript-component'],

    player: Ember.inject.service(),

    autoscroll: true,
    autoscrollElement : '.corpus-app-container',
    timeout: null,

    itemObserver: Ember.observer('player.item', function () {
        this.set('autoscroll', true);
    }),

    didUpdate: function() {
        var self = this;
        if(this.get('autoscroll')) {
            Ember.$(this.get('autoscrollElement')).animate({
                scrollTop: Ember.$('.sentence.active').offset().top + Ember.$(this.get('autoscrollElement')).scrollTop() - Ember.$(this.get('autoscrollElement')).offset().top - 154
            }, 150);
        }
    },

    actions: {

        play: function(progress) {
            this.get('player').trigger('progressupdate', progress);
            this.get('player').set('playing', true);
        }

    }

});
