import Ember from 'ember';

export default Ember.Service.extend(Ember.Evented, {

    items: [],
    item: null,
    model: null,

    window: '',
    playing: false,
    progress: 0, // In Milliseconds
    reduce: false,

    init: function() {
        this.on('reset', Ember.run.bind(this, this.get('reset')));
    },

    setProgress: function(time) {
        this.set('progress', time);
    },

    play: function(id) {
        this.set('item', id);
        this.set('playing', true);
    },

    pause: function() {
        this.set('playing', false);
    },

    reset: function(id) {
        this.set('item', id);
    }
});
