import Ember from 'ember';
import { documentContributorRoleTranslationTag } from 'bo-client/helpers/document-contributor-role-translation-tag';

export default Ember.Component.extend({
  i18n: Ember.inject.service(),
  tagName: "td",
  isEditing: false,
  valueChanged: Ember.K,

  translatedRole: Ember.computed('role', function() {
    var role = this.get('role');
    return role?this.get('i18n').t(documentContributorRoleTranslationTag([role,])):'';
  }),

  _roleChanged: Ember.observer('role', function() {
    this.get('valueChanged')();
  }),

  _selectComponentChanged: Ember.observer('selectComponent', function() {
    if(this.get('isEditing') && this.get('selectComponent')) {
      this.get('selectComponent').$().focus();
    }
  }),

});
