<?php
namespace CorpusParole\Providers;

use Illuminate\Support\ServiceProvider;

/**
 * Service provider charged to bind repository interfaces to implementations
 */
class RepositoryServiceProvider extends ServiceProvider {

    public function register() {
        $this->app->bind(
            'CorpusParole\Repositories\DocumentRepository',
            function($app) {
                $cpSparqlClient = $app->make('CorpusParole\Libraries\Sparql\SparqlClient');
                return $app->make('CorpusParole\Repositories\RdfDocumentRepository', [$cpSparqlClient,]);
            }
        );
    }
}
