# Corpus CMS

This README describes how to generate a Drupal module embedding a ember app.

## Prerequisites

You will need the following things properly installed on your computer.

* [Node.js](http://nodejs.org/) (with NPM)

## Installation

* `npm install` (install gulp and some dependencies)
* In the /app-client directory
  * `npm install` (install the dependencies of the ember app)
  * `bower install`

### Building

To build the module, you need to build the ember app then to copy the correct files into the modules folder. It can easily be done by the following command line:

* `npm run build`

It will first run `npm run build --prefix app-client` which will build the ember app, and then run `gulp copy-module` to copy the built files into the module folder.

**Don't Forget !**

If the config/environnement.js has been modified, you must get the new meta line in dist/index.html
> `<meta name="app-client/config/environment" content="ELEMENTS_FROM_CONFIG" />`

And copy it in corpus_module/corpus.module in the function `corpus_page()`
```php
<?php
function corpus_page() {
...
$element = array(
    '#tag' => 'meta', // The #tag is the html tag - <link />
   '#attributes' => array( // Set up an array of attributes inside the tag
     'name' => 'app-client/config/environment',
     'content' => 'ELEMENTS_FROM_CONFIG'
   ),
 );
 ```

 Finally replace the `baseStatic` value by `/'.drupal_get_path('module', 'corpus').'/app-client/`. This way, Drupal will fill the value with the correct path to the corpus module.

### Deploy

Once the module has been updated with the correct built app, you can **compress** it and **share it**.
To include the compressed module to a Drupal website, simply **unzip** the module and place it in the `modules/ folder` in your Drupal project.
Report to the **README** inside the module folder for further informations.
