import DS from 'ember-data';

export default DS.JSONSerializer.extend({

      normalizeResponse: function(store, primaryModelClass, payload) {
        var data = [];
        var languages = payload['languages'];
        Object.keys(languages).forEach(function(key) {
            data.push({
                'id': key,
                'type': 'language',
                'attributes': {
                    'count': languages[key]
                }
            });
        });
        return {
            'data': data
        };
    }

});
