import Ember from 'ember';
import * as utils from 'corpus-common-addon/utils/utils';

export function getLinkType(params /* , hash */) {
  const url = params[0];

  if (!url) {
    return 'doc-literal';
  }
  if (utils.isLexvoLink(url)) {
    return 'doc-language';
  }
  if (utils.isBnfLink(url)) {
    return 'doc-subject';
  }
  if (utils.isGeonamesLink(url)) {
    return 'doc-location';
  }
  if (utils.isViafLink(url)) {
    return 'doc-contributor';
  }
  if (utils.isOLACLiteral(url)) {
    return 'doc-olac';
  }

  return 'doc-literal';
}

export default Ember.Helper.helper(getLinkType);
