DruStack
========

[DruStack](http://drupal.org/project/drustack) is a freely available
packaged distribution of the open source Drupal system. A collection of
most common software from the Drupal community,
[DruStack](http://drupal.org/project/drustack) provides a quick on-ramp
to begin building Drupal websites.

[DruStack](http://drupal.org/project/drustack) integrated the
development for Drupal installation. The pre-configured modules make you
get a highly customized and total complete Drupal websites. You can get
your own ready-made Blog setup by default Drupal installation procedure.

DruStack replace most of the features and as a successor of [PantaRei
Siren](http://drupal.org/project/pantarei_siren) distribution.

Features Highlight
------------------

-   Collection of 3rd party modules tested, verified and supported by
    [PantaRei Design](http://drupal.org/node/1741828).
-   Pre-configured with commonly used functionality, including testing
    user account, roles, permission, input filter, WYSIWYG, and
    even more.
-   Integrated with frequently-used 3rd party libraries, e.g.
    [CKEditor](http://ckeditor.com/), [HTML
    Purifier](http://htmlpurifier.org/),
    [Colorbox](http://colorpowered.com/colorbox/), [Code
    prettify](http://code.google.com/p/google-code-prettify/), etc.
-   Most setup managed by Features and Strongarm with drustack\_\*
    packages so you may rollback as default whenever required.

Getting Start
-------------

### Standard Package

Standard Package include both GPLv2+ compatibile
modules/themes/libraries as [Drupal.org Library Packaging
Whitelist](https://drupal.org/project/drupalorg_whitelist) required,
plus [TWBS](https://drupal.org/project/twbs) related packages for
[Bootstrap](http://getbootstrap.com/) mobile-first design integration.

If you are new with DruStack and hope to give a trial without any setup
overhead, please feel free to try DruStack on
[simplytest.me](http://simplytest.me/project/drustack), or simply
download it and install as like as normal Drupal core.

### Manual Installation Script with [Drush](https://github.com/drush-ops/drush)

Full Package (-f) include all modules/themes/libaries within our
collections, plus all patches for bugfix or usability improvement. Most
packages are tested in version compatibile, which site builder can
kickstart a new site without searching around popular projects.

Source Package (-s) preserves VCS directories, link .git, for all Full
Package contents. A developer can get start with R&D and debug all in
GIT style without additional overhead, correct tag/branch will also
checkout for you automatically.

With [Drush](https://github.com/drush-ops/drush) installed you may
execute following build script directly for standard version ready for
initial installation:

    # Standard package for initial installation.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh)

Script options may combine as below:

    # Print help message.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh) -h

    # Full package for initial installation.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh) -f

    # Full package (with source) for initial installation.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh) -fs

    # Full package for upgrade.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh) -fu

    # Full package (with source) for upgrade.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh) -fus

    # Full package (with source, version 8.x-0.x) for upgrade.
    bash <(curl -sL http://cgit.drupalcode.org/drustack/plain/drustack.sh) -fus -v 8.x-0.x

Author
------

-   Developed by [Edison Wong](http://drupal.org/user/33940).
-   Sponsored by [PantaRei Design](http://drupal.org/node/1741828).
