import Ember from 'ember';

export default Ember.Controller.extend({
  queryParams: ['location', 'langue', 'discours', 'date', 'thematique'],
  location: null,
  langue: null,
  discours: null,
  date: [],
  thematique: null,
  isShowingModal: false,
  currentDetails: null,
  currentItem: {title: "example", master: 'http://www.noiseaddicts.com/samples_1w72b820/3921.mp3'},
  filteredSounds: Ember.computed('location', 'langue', 'discours', 'date', 'thematique', 'model', function() {
    var location = this.get('location');
    var langue = this.get('langue');
    var discours = this.get('discours');
    var date = this.get('date');
    var thematique = this.get('thematique');

    var sounds = this.get('model');

    if (location) {
      sounds = sounds.filterBy('spatial', location);
    }
    if (langue) {
      sounds = sounds.filterBy('language', langue);
    }
    if (discours) {
      sounds = sounds.filterBy('type', discours);
    }
    if (date.length > 0) {
      var temp = sounds;
      sounds.map(function(elt){
        if (date.indexOf(elt.get('created')) === -1){
          temp = temp.without(elt);
        }
      });
      sounds = temp;
    }
    if (thematique) {
      sounds = sounds.filterBy('thematique', thematique);
    }
    return sounds;
  }),
  actions: {
    deleteTag: function(query, item){
      var queryParams = {},
          newParams = null;
      if (query === 'date'){
        newParams = this.get('date');
        if(newParams.indexOf(item) !== -1) {
        	newParams = newParams.splice(newParams.indexOf(item), 1);
        }
      }
      queryParams[query] = newParams;
      this.transitionToRoute({queryParams: queryParams});
    },
    changeSong: function(songDirection){
      var direction = (songDirection === "next") ? 1 : -1;
      var index = this.get("filteredSounds").indexOf(this.get("currentItem"));
      if ( index !== -1){
          if (typeof(this.get("filteredSounds").objectAt(index+direction)) !== 'undefined'){
            return this.set('currentItem', this.get("filteredSounds").objectAt(index+direction));
          }
      }
      return this.set('currentItem', this.get('filteredSounds').get('firstObject'));
    },
    play: function(item){
      this.set("currentItem", item);
      Ember.$(".result-item").toggleClass("playing", false);
      Ember.$("#"+item.id).toggleClass("playing", true);
    },
    details: function(item){
      if (Ember.$("#"+item.id).hasClass("details")){
          Ember.$("#"+item.id).toggleClass("details", false);
      } else{
        Ember.$(".result-item").toggleClass("details", false);
        Ember.$("#"+item.id).toggleClass("details", true);
      }
    },
    toggleModal: function(item){
      this.set("isShowingModal", !this.isShowingModal);
      this.set("currentDetails", item);
    }
  }
});
