import Ember from 'ember';

export default Ember.Component.extend({
  didInsertElement: function(){
    var _this = this;

    if (this.get('container').lookup('controller:application').date !== null){
      this.highlightQuery(this.get('container').lookup('controller:application').date);
    }

    var isMouseDown = false,
      isHighlighted;
    $("#our_table li").mousedown(function () {
      isMouseDown = true;
      $(this).toggleClass("highlighted");
      isHighlighted = $(this).hasClass("highlighted");
      _this.sendUpdate();
      return false; // prevent text selection
    }).mouseover(function () {
      if (isMouseDown) {
        $(this).toggleClass("highlighted", isHighlighted);
        _this.sendUpdate();
      }
    }).bind("selectstart", function () {
      return false;
    })

    $(document).mouseup(function () {
      isMouseDown = false;
    });
  },
  sendUpdate: function(){
    var dateQuery = [];
    $('.highlighted').map(function(index, elt) {
      dateQuery.push(parseInt($(elt).parent().attr('id')) + parseInt($(elt).html()));
    });
    this.sendAction('action', dateQuery);
  },
  highlightQuery: function(list){
    list.map(function(elt, index){
      var year = Math.floor(parseInt(elt)/10)*10;
      $("#"+year+" ."+(parseInt(elt)-year)).toggleClass("highlighted", true);
    });
  }
});
