import Ember from 'ember';

export default Ember.Component.extend({

    filter: '',

    filteredThemes: Ember.computed.filter('themes', function(item) {
        return this.get('filter') && (item.get('label') || '').match(this.get('filter'));
    }).property('filter'),

    actions: {

        setQueryParameters: function(id) {
            this.get('setQueryParameters')(id);
        },

        filterBy: function(input) {
            this.set('filter', input && new RegExp('^' + input));
            this.get('filteredThemes');
        }

    }


});
