<?php
namespace CorpusParole\Models;

use CorpusParole\Libraries\RdfModel\RdfModelResource;
use CorpusParole\Libraries\Utils;
use JsonSerializable;
use Log;

/**
 */
class GeoResource extends RdfModelResource implements JsonSerializable {

    public function __construct($uri, $graph) {
        parent::__construct($uri, $graph);
    }

    private $refLocs = null;
    private $notes = null;

    public function clearMemoizationCache() {
        $this->refLocs = null;
        $this->notes = null;
    }

    public function getRefLocs() {
        if(is_null($this->refLocs)) {
            $refLocs = $this->allResources("<http://www.w3.org/2002/07/owl#sameAs>");
            $this->refLocs = array_map(function($refLoc) { return $refLoc->getUri();}, $refLocs);
        }
        return $this->refLocs;
    }

    public function getNotes() {
        if(is_null($this->notes)) {
            $this->notes = $this->all('<http://www.w3.org/2004/02/skos/core#note>');
        }
        return $this->notes;
    }

    public function jsonSerialize() {
        $notes = array_map(
            function($note) { return Utils::processLiteralResourceOrString($note); },
            $this->getNotes()
        );
        return [
            'ref-locs' => $this->getRefLocs(),
            'notes' => $notes
        ];
    }

}