import Ember from 'ember';

export default Ember.Component.extend({

    player: Ember.inject.service(),

    classNames: ['notice-component'],

    item: Ember.computed('player.model', function() {
        return this.get('player').get('model');
    }),

    participants: Ember.computed('player.model.contributors', function() {
        var participants = [];
        if(this.get('player').get('model')) {
            this.get('player').get('model').get('contributors').forEach(function(contributor) {
                if(contributor.name) {
                    participants.push({ name: contributor.name, role: contributor.role.split('/').pop() });
                }
            });
        }
        return participants;
    }),

    location: Ember.computed('player.model.geoInfo', function() {
        var location = '';
        if(this.get('player').get('model')) {
            var meta = this.get('player').get('model').get('geoInfo').notes.find(element => element.lang);
            if(meta) {
                location = meta.value;
            }
        }
        return location;
    })

});
