<?php
/**
 * @file
 * corpus_structures_et_contenus.pages_default.inc
 */

/**
 * Implements hook_default_page_manager_pages().
 */
function corpus_structures_et_contenus_default_page_manager_pages() {
  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'corpus';
  $page->task = 'page';
  $page->admin_title = 'Corpus';
  $page->admin_description = 'descript corpus';
  $page->path = 'corpus';
  $page->access = array();
  $page->menu = array(
    'type' => 'normal',
    'title' => 'Corpus',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_corpus__panel';
  $handler->task = 'page';
  $handler->subtask = 'corpus';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Corpus',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => 'corpus-page',
    'css_id' => '',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Taxonomy term',
        'keyword' => 'taxonomy_term',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '1',
        'id' => 1,
      ),
    ),
    'relationships' => array(
      0 => array(
        'identifier' => 'Taxonomy vocabulary from Taxonomy term (on taxonomy_term_data.vocabulary)',
        'keyword' => 'taxonomy_vocabulary',
        'name' => 'entity_from_schema:vid-taxonomy_term-taxonomy_vocabulary',
        'context' => 'context_entity:taxonomy_term_1',
        'id' => 1,
      ),
    ),
    'name' => 'panel',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => array(
        'css_id' => '',
        'css_class' => 'row',
        'column' => array(
          'xs' => '1',
          'sm' => '1',
          'md' => '1',
          'lg' => '1',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'top' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '12',
          'lg' => '12',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '6',
          'lg' => '6',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '6',
          'lg' => '6',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
    'style' => 'bootstrap_region',
    'top' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Titre Page Corpus';
  $display->uuid = 'dc9c91a8-8045-45e5-aaca-89b0ff37b338';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_corpus__panel';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'texte corpus',
    'title' => '',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.&nbsp;</p>

<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.&nbsp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in.</p>

<p>Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
    'style' => 'default',
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $display->content['new-e43762a6-06d6-45cb-b947-cf5c9611a1e6'] = $pane;
  $display->panels['left'][0] = 'new-e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $pane = new stdClass();
  $pane->pid = 'new-0e7c474c-7665-4b24-93d3-ed07236045e7';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'blocs_image_corpus_langues_etc';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '4',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block',
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h2',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '0e7c474c-7665-4b24-93d3-ed07236045e7';
  $display->content['new-0e7c474c-7665-4b24-93d3-ed07236045e7'] = $pane;
  $display->panels['right'][0] = 'new-0e7c474c-7665-4b24-93d3-ed07236045e7';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['corpus'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'langues';
  $page->task = 'page';
  $page->admin_title = 'Langues';
  $page->admin_description = 'descript langues';
  $page->path = 'langues';
  $page->access = array();
  $page->menu = array(
    'type' => 'normal',
    'title' => 'Langues',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues__langues';
  $handler->task = 'page';
  $handler->subtask = 'langues';
  $handler->handler = 'panel_context';
  $handler->weight = 1;
  $handler->conf = array(
    'title' => 'Langues',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => 'corpus-page',
    'css_id' => '',
    'css' => '',
    'contexts' => array(),
    'relationships' => array(),
    'name' => 'langues',
  );
  $display = new panels_display();
  $display->layout = 'onecol';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => array(
        'css_id' => '',
        'css_class' => 'row',
        'column' => array(
          'xs' => '1',
          'sm' => '1',
          'md' => '1',
          'lg' => '1',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '6',
          'lg' => '6',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '6',
          'lg' => '6',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
      'middle' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '12',
          'lg' => '12',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
    'style' => 'bootstrap_region',
    'middle' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Toutes les langues';
  $display->uuid = 'dc9c91a8-8045-45e5-aaca-89b0ff37b338';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues__langues';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-26baffa1-cb48-458c-95a2-bb55282237b0';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Description langue Française',
    'title' => '',
    'body' => '<p>La France dispose d&rsquo;un patrimoine linguistique d&rsquo;une grande richesse. &Agrave; c&ocirc;t&eacute; du fran&ccedil;ais, langue nationale, dont le caract&egrave;re officiel est inscrit depuis 1992 dans la Constitution, les langues de France sont notre bien commun, elles contribuent &agrave; la cr&eacute;ativit&eacute; de notre pays et &agrave; son rayonnement culturel. On entend par langues de France les langues r&eacute;gionales ou minoritaires parl&eacute;es par des citoyens fran&ccedil;ais sur le territoire de la R&eacute;publique depuis assez longtemps pour faire partie du patrimoine culturel national, et ne sont langue officielle d&rsquo;aucun &Eacute;tat.</p>
',
    'format' => 'basic_html',
    'substitute' => TRUE,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '26baffa1-cb48-458c-95a2-bb55282237b0';
  $display->content['new-26baffa1-cb48-458c-95a2-bb55282237b0'] = $pane;
  $display->panels['middle'][0] = 'new-26baffa1-cb48-458c-95a2-bb55282237b0';
  $pane = new stdClass();
  $pane->pid = 'new-d0530eb3-0c9b-4c3e-955f-d7c2a2300300';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block',
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h2',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 1;
  $pane->locks = array();
  $pane->uuid = 'd0530eb3-0c9b-4c3e-955f-d7c2a2300300';
  $display->content['new-d0530eb3-0c9b-4c3e-955f-d7c2a2300300'] = $pane;
  $display->panels['middle'][1] = 'new-d0530eb3-0c9b-4c3e-955f-d7c2a2300300';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = '0';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['langues'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'langues_de_france';
  $page->task = 'page';
  $page->admin_title = 'Langues de France';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-de-france';
  $page->access = array();
  $page->menu = array(
    'type' => 'normal',
    'title' => 'Langues de France',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues_de_france__panel';
  $handler->task = 'page';
  $handler->subtask = 'langues_de_france';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Langues de France',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_de_france',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Langues regionales hexagonales',
        'keyword' => 'taxonomy_term_langues_regionales_hexagonales',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '4',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => 'panel',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => NULL,
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues_de_france__panel';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte langues de France',
    'title' => '',
    'body' => '<p>La France dispose d&rsquo;un patrimoine linguistique d&rsquo;une grande richesse.<br />
&Agrave; c&ocirc;t&eacute; du fran&ccedil;ais, langue nationale, dont le caract&egrave;re officiel est inscrit depuis 1992 dans la Constitution, les langues de France sont notre bien commun, elles contribuent &agrave; la cr&eacute;ativit&eacute; de notre pays et &agrave; son rayonnement culturel.<br />
On entend par langues de France les langues r&eacute;gionales ou minoritaires parl&eacute;es par des citoyens fran&ccedil;ais sur le territoire de la R&eacute;publique depuis assez longtemps pour faire partie du patrimoine culturel national, et ne sont langue officielle d&rsquo;aucun &Eacute;tat.</p>

<p>C&rsquo;est pourquoi par exemple n&rsquo;en font partie ni le portugais ni le chinois, pourtant parl&eacute;s par de nombreux citoyens fran&ccedil;ais&nbsp;:<br />
outre que ces langues ne sont pas menac&eacute;es, elles sont r&eacute;guli&egrave;rement enseign&eacute;es dans le syst&egrave;me &eacute;ducatif comme langues &eacute;trang&egrave;res.<br />
L&rsquo;arm&eacute;nien occidental langue de France est celui de la diaspora, distinct de l&rsquo;arm&eacute;nien oriental, langue officielle de la R&eacute;publique d&rsquo;Arm&eacute;nie. Les diff&eacute;rentes vari&eacute;t&eacute;s d&rsquo;arabe pratiqu&eacute;es par de nombreux Fran&ccedil;ais se distinguent de l&rsquo;arabe dit litt&eacute;ral ou classique, langue officielle de plusieurs pays, utilis&eacute; aussi dans les m&eacute;dias, mais qui ne repose pas sur un usage populaire concret.<br />
Ces crit&egrave;res de d&eacute;finition s&rsquo;inspirent, en l&rsquo;adaptant, de la Charte&nbsp;<br />
Il est donc amen&eacute; &agrave; expertiser et &agrave; soutenir des projets de recherche qui rel&egrave;vent de la probl&eacute;matique des langues de France.</p>

<p>La D&eacute;l&eacute;gation est &eacute;galement &agrave; l&rsquo;origine de plusieurs publications, notamment d&rsquo;un R&eacute;pertoire des organismes actifs dans le domaine des langues de France, et d&rsquo;ouvrages qui popularisent aupr&egrave;s du grand public la r&eacute;alit&eacute; linguistique nationale, &agrave; la fois riche<br />
et m&eacute;connue.</p>

<p>Le site&nbsp;<a href="http://www.culture.gouv.fr/culture/dglf/">dglf.culture.gouv.fr</a>&nbsp;pr&eacute;sente plusieurs rubriques relatives aux langues de France, des textes de r&eacute;f&eacute;rence, des listes de ressources et des liens. Parmi ces liens,<br />
le site&nbsp;<a href="http://www.languesdefranceenchansons.com/index_flash.html">languesdefranceenchansons.com</a><br />
propose de d&eacute;couvrir la richesse traditionnelle et contemporaine de notre pluralit&eacute; linguistique.<br />
En contribuant &agrave; une meilleure connaissance des langues de France, mais aussi &agrave; leur d&eacute;veloppement cr&eacute;atif, l&rsquo;action du minist&egrave;re de la Culture et de la Communication illustre et soutient les grands choix de notre pays en faveur du plurilinguisme et de la diversit&eacute; culturelle.</p>

<h3><strong>Liste des langues de France</strong></h3>

<p><strong>France m&eacute;tropolitaine</strong></p>

<p><em>Langues r&eacute;gionales</em>&nbsp;:</p>

<p>basque, breton, catalan, corse, dialectes allemands d&rsquo;Alsace et de Moselle (alsacien et francique mosellan), flamand occidental, francoproven&ccedil;al, langues d&rsquo;o&iuml;l (franc-comtois, wallon, champenois, picard,<br />
normand, gallo, poitevin, saintongeais, lorrain, bourguignon-morvandiau), langue d&rsquo;oc ou occitan (gascon, languedocien,<br />
proven&ccedil;al, auvergnat, limousin, vivaro-alpin), parlers liguriens.</p>

<p><img alt="" src="http://mcc.dev:8890/sites/default/files/langues/carte_de_france_lr.png" style="height:550px; width:510px" /></p>

<p><em>Langues non-territoriales&nbsp;:</em></p>

<p>arabe maghr&eacute;bin, arm&eacute;nien occidental, berb&egrave;re, jud&eacute;o-espagnol,<br />
romani, yiddish.</p>

<p><strong>Outre-mer</strong></p>

<p><em>Zone cara&iuml;be&nbsp;:</em>&nbsp;<br />
<em>Cr&eacute;oles &agrave; base lexicale fran&ccedil;aise</em>&nbsp;: guadeloup&eacute;en, martiniquais&nbsp;;</p>

<p><em>Guyane&nbsp;:&nbsp;</em>cr&eacute;ole guyanais, langues am&eacute;rindiennes&nbsp;: kali&rsquo;na (ou galibi)<br />
wayana, palikur, arawak (ou lokono), wayampi, &eacute;merillon&nbsp;; cr&eacute;oles bushinenge (&agrave; base lexicale anglaise ou anglo-portugaise)&nbsp;: saramaca, aluku,njuka, paramaca&nbsp;; et hmong.</p>

<p><em>R&eacute;union&nbsp;:</em>&nbsp;cr&eacute;ole r&eacute;unionnais (&agrave; base lexicale fran&ccedil;aise).</p>

<p><em>Mayotte&nbsp;:</em>&nbsp;mahorais, malgache de Mayotte.</p>

<p><em>Nouvelle Cal&eacute;donie</em>&nbsp;(vingt-huit langues kanak)&nbsp;:&nbsp;<em>Grande terre</em>&nbsp;: nyel&acirc;yu, kumak, caac, yuaga, jawe, nemi, fw&acirc;i, pije, pwaamei, pwapw&acirc;, langue de Voh-Kon&eacute;, c&egrave;muhi, paic&icirc;, aji&euml;, arh&acirc;, arh&ouml;, &lsquo;&ocirc;r&ocirc;&ecirc;, neku, s&icirc;ch&euml;, t&icirc;r&icirc;, x&acirc;r&acirc;c&ugrave;&ugrave;, xaragur&egrave;, drub&eacute;a, num&egrave;&egrave;&nbsp;;&nbsp;<em>Iles Loyaut&eacute;&nbsp;:</em>&nbsp;nengone, drehu, iaai, fagauvea.</p>

<p><em>Polyn&eacute;sie fran&ccedil;aise&nbsp;:</em>&nbsp;tahitien, marquisien, langue des Tuamotu, langue mangar&eacute;vienne&nbsp;; langues des Iles Australes&nbsp;: langue de Ra&rsquo;ivavae, langue de Rapa, langue de Ruturu.</p>

<p><em>Wallis et Futuna&nbsp;:</em>&nbsp;wallisien, futunien.</p>

<p><em>La langue des signes fran&ccedil;aise (LSF)</em><br />
Utilis&eacute;e traditionnellement par des citoyens fran&ccedil;ais, c&rsquo;est aussi une langue de France.</p>
',
    'format' => 'full_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['left'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues régionales',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['right'][0] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['langues_de_france'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'langues_de_guyane';
  $page->task = 'page';
  $page->admin_title = 'Langues de Guyane';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-de-guyane';
  $page->access = array();
  $page->menu = array(
    'type' => 'none',
    'title' => 'Langues de Guyane',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues_de_guyane__panel_context_2f901340-c4ec-4e0c-8b91-173cf42facfc';
  $handler->task = 'page';
  $handler->subtask = 'langues_de_guyane';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Langues de Guyane',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_de_guyane',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Zone Caraibe',
        'keyword' => 'taxonomy_term_zone_caraibe',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '7',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => '',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => NULL,
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Langues de Guyane';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues_de_guyane__panel_context_2f901340-c4ec-4e0c-8b91-173cf42facfc';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte langues de Guyane',
    'title' => '',
    'body' => '<p>La Guyane fran&ccedil;aise offre un cas typique de grand plurilinguisme pour une population restreinte (&eacute;valu&eacute;e &agrave; 170 000 personnes). Outre le fran&ccedil;ais, langue officielle, sont parl&eacute;es des langues de migrants - donc langues &eacute;trang&egrave;res - mais aussi une dizaine de langues qui pr&eacute;sentent les caract&eacute;ristiques des langues r&eacute;gionales (citoyennet&eacute;&nbsp;: elles sont parl&eacute;es par des citoyens fran&ccedil;ais, et territorialisation&nbsp;: elles sont parl&eacute;es dans des zones identifiables du territoire fran&ccedil;ais). Elles seront pr&eacute;sent&eacute;es en quatre groupes&nbsp;:</p>

<p>-&nbsp; le&nbsp;<a href="/spip.php?article49">Cr&eacute;ole guyanais</a><br />
-&nbsp; les langues am&eacute;rindiennes&nbsp;<br />
-&nbsp; les cr&eacute;oles noirs marrons (ou langues businenge)<br />
-&nbsp; le&nbsp;<a href="/spip.php?article58">hmong</a></p>

<p>Chacun de ces groupes de langues, voire chaque langue au sein d&rsquo;un groupe, pose des probl&egrave;mes sp&eacute;cifiques qui peuvent n&eacute;cessiter une approche diversifi&eacute;e (selon le chiffre de population, la zone g&eacute;ographique, le statut social des locuteurs ou le niveau d&rsquo;alt&eacute;rit&eacute; proprement linguistique de la langue). On donnera donc un certain nombre d&rsquo;indications d&rsquo;ordre linguistique et sociolinguistique &agrave; propos de chacune de ces langues.</p>

<p>En l&rsquo;absence de statistique officielle qui serait issue d&rsquo;une enqu&ecirc;te rigoureusement men&eacute;e sur les langues parl&eacute;es en territoire fran&ccedil;ais, le nombre de locuteurs est de toutes ces donn&eacute;es celle qui peut pr&ecirc;ter le plus &agrave; controverse. On sait d&rsquo;autre part que l&agrave; o&ugrave; une partie importante des locuteurs d&rsquo;une langue est en train de l&rsquo;abandonner au profit d&rsquo;une autre (dans le cas de la Guyane, essentiellement le fran&ccedil;ais ou le cr&eacute;ole), la notion de locuteur d&rsquo;une langue peut devenir floue. On est donc dans une situation mouvante, ce qui explique que les estimations ant&eacute;rieures varient souvent du simple au double. Les chiffres cit&eacute;s ici refl&egrave;teront cette prudence. On mentionnera cependant dans plusieurs cas les chiffres en g&eacute;n&eacute;ral assez pr&eacute;cis correspondant &agrave; un recensement effectu&eacute; il y a quelques ann&eacute;es par Fran&ccedil;oise et Pierre Grenand, ainsi que celui effectu&eacute; r&eacute;cemment par R&amp;S.Price (2002) pour les Noirs Marrons. Pour les pays voisins, on s&rsquo;est appuy&eacute; sur les donn&eacute;es figurant dans l&rsquo;ouvrage As l&iacute;nguas amaz&ocirc;nicas hoje, F. Queixal&oacute;s et O. Renault-Lescure (&eacute;ds.), IRD-ISA-MPEG, S&atilde;o Paulo, publi&eacute; en 2000.</p>

<h3>Les langues am&eacute;rindiennes</h3>

<p>Ce sont les langues autochtones au sens strict, parl&eacute;es par les premiers habitants du pays. Elles sont au nombre de six, r&eacute;parties entre trois des grandes familles linguistiques de l&rsquo;Am&eacute;rique du Sud.</p>

<p><strong>Famille caribe</strong></p>

<p>(ou karib, on trouve aussi cariban en anglais). En Guyane, les deux langues appartenant &agrave; cette famille sont le kali&rsquo;na et le wayana. La famille caribe comprend une trentaine de langues parl&eacute;es dans les pays du Nord de l&rsquo;Am&eacute;rique du Sud, autour de l&rsquo;Amazone. Dans le Nord du bassin amazonien, elles s&rsquo;&eacute;tendent jusqu&rsquo;&agrave; la c&ocirc;te&nbsp;; dans le Sud, elles vont jusqu&rsquo;&agrave; la haute vall&eacute;e du Xingu. Les plus occidentales de ces langues sont le carijona (Colombie) et le yukpa (Colombie et Venezuela)<br />
N.B. La langue dite cara&iuml;be (insulaire) qui &eacute;tait parl&eacute;e aux Petites Antilles au XVIIe si&egrave;cle (et d&eacute;crite dans le Dictionnaire Cara&iuml;be du P. Breton de 1665) est en fait une langue de base arawak (v. &agrave; arawak), mais avec une tr&egrave;s forte influence caribe dans le vocabulaire.</p>

<p><strong>Famille arawak</strong></p>

<p>En Guyane, cette famille est repr&eacute;sent&eacute;e par l&rsquo;arawak (proprement dit), appel&eacute; aussi lokono, et par le palikur. La famille arawak (qu&rsquo;il ne faut pas confondre avec la langue arawak &ldquo;proprement dite&rdquo; ou lokono) comprend une trentaine de langues parl&eacute;es sur la c&ocirc;te Nord de l&rsquo;Am&eacute;rique du Sud (la plus importante &eacute;tant le wayuu ou guajiro de la fronti&egrave;re Colombie-Venezuela), dans la zone amazonienne (P&eacute;rou, Br&eacute;sil, Bolivie) et jusqu&rsquo;en Am&eacute;rique Centrale (le garifuna, dit aussi Black Carib, parl&eacute; au Belize, au Honduras, au Guatemala et dans une importante diaspora aux Etats-Unis&nbsp;: cette langue est une &eacute;volution du Cara&iuml;be insulaire, v. ci-dessus &agrave; caribe).</p>

<p><strong>Famille tupi-guarani</strong></p>

<p>Deux langues de cette famille sont parl&eacute;es en Guyane&nbsp;: le wayampi et l&rsquo;&eacute;m&eacute;rillon. La Guyane repr&eacute;sente l&rsquo;extension la plus septentrionale de cette famille linguistique tr&egrave;s pr&eacute;sente dans le bassin amazonien (36 langues) et qui s&rsquo;&eacute;tend au Sud jusqu&rsquo;en Argentine. La principale langue de la famille est le guarani, parl&eacute; par plusieurs millions de personnes au Paraguay, en Argentine et au Br&eacute;sil, et actuellement officialis&eacute; au Paraguay&nbsp;; une autre langue tr&egrave;s voisine &eacute;tait au XVIIe si&egrave;cle la langue v&eacute;hiculaire (lingua geral) dans tout le Br&eacute;sil colonial.</p>

<p><strong>Voir aussi&nbsp;:</strong></p>

<p><a href="/spip.php?article50">Kali&rsquo;na</a>&nbsp;<br />
<a href="/spip.php?article51">Wayana</a></p>

<p><a href="/spip.php?article52">Arawak</a>&nbsp;<br />
<a href="/spip.php?article53">Palikur</a></p>

<p><a href="/spip.php?article54">Wayampi</a>&nbsp;<br />
<a href="/spip.php?article55">&Eacute;m&eacute;rillon</a></p>

<h3>Les langues businenge ou cr&eacute;oles noirs marrons, g&eacute;n&eacute;ralit&eacute;s</h3>

<p>Le groupe des langues cr&eacute;oles de base anglaise de Guyane et du Surinam</p>

<p><strong>R&eacute;partition linguistique</strong></p>

<p>Ce groupe de langues cr&eacute;oles rassemble 7 variantes linguistiques dont 5 sont repr&eacute;sent&eacute;es en Guyane fran&ccedil;aise&nbsp;: l&rsquo;aluku, le ndjuka, le paramaka, le saramaka (qui peuvent pr&eacute;tendre au statut de langues r&eacute;gionales), et le sranan tongo, langue v&eacute;hiculaire utilis&eacute;e notamment le long du fleuve Maroni. Les deux autres formes linguistiques de ce groupe sont le kwinti et le matawai, parl&eacute;s exclusivement au Surinam. Du point de vue linguistique, on distingue deux sous-groupes&nbsp;:<br />
-&nbsp;cr&eacute;oles de base dominante anglaise&nbsp;: aluku, ndjuka, paramaka, sranan tongo (ainsi que le kwinti du Surinam)<br />
-&nbsp;cr&eacute;oles de base anglaise relexifi&eacute;s &agrave; partir du portugais&nbsp;: saramaka (ainsi que le matawai du Surinam).</p>

<p><strong>R&eacute;partition sociolinguistique</strong></p>

<p>Ces langues correspondent &agrave; des usages et des groupes tr&egrave;s diff&eacute;renci&eacute;s sociologiquement. On distingue l&agrave; encore deux sous-groupes qui ne recouvrent pas les sous-groupes linguistiques&nbsp;:<br />
-&nbsp;le sranan tongo&nbsp;: &agrave; l&rsquo;origine langue des Cr&eacute;oles du Surinam, elle est la langue v&eacute;hiculaire la plus r&eacute;pandue de ce pays, et sert &eacute;galement de v&eacute;hiculaire dans l&rsquo;Ouest guyanais (r&eacute;gion de Saint Laurent). Elle est utilis&eacute;e dans les &eacute;changes extra-communautaires (entre Noirs Marrons et Am&eacute;rindiens&nbsp;; entre Noirs Marrons et Cr&eacute;oles guyanais&nbsp;; entre Noirs marrons et m&eacute;tropolitains)<br />
-&nbsp;les langues des Noirs Marrons (appel&eacute;es aussi langues businenge ou bushinenge)&nbsp;: il s&rsquo;agit de langues parl&eacute;es par les descendants des Marrons qui, d&egrave;s le d&eacute;but du syst&egrave;me esclavagiste, se sont enfuis des plantations (voir le panorama historique pour plus de d&eacute;tails)&nbsp;: ce sont tous les autres parlers cit&eacute;s.</p>

<p><strong>A propos du &quot;taki-taki&quot;</strong></p>

<p>Le terme taki-taki, tr&egrave;s couramment utilis&eacute;, est pourtant &agrave; &eacute;viter pour deux raisons&nbsp;: 1. il est d&eacute;pr&eacute;ciatif et surtout 2. il est ambigu, puisqu&rsquo;il peut d&eacute;signer alternativement n&rsquo;importe lequel des parlers businenge, mais aussi le sranan-tongo, ou une variante de &lsquo;sranan tongo langue &eacute;trang&egrave;re&rsquo; qui se d&eacute;veloppe &agrave; Saint-Laurent chez les populations non businenge.</p>

<p><strong>Voir aussi&nbsp;:</strong></p>

<p><a href="/spip.php?article56">Aluku, ndjuka, paramaka</a></p>

<p><a href="/spip.php?article57">Saramaka</a></p>

<h3>Autres langues parl&eacute;es en Guyane</h3>

<p>La Guyane &eacute;tant terre d&rsquo;immigration, de tr&egrave;s nombreux &eacute;trangers, Fran&ccedil;ais d&rsquo;origine &eacute;trang&egrave;re, voire Fran&ccedil;ais d&rsquo;autres DOM-TOM, peuvent parler des langues non cit&eacute;es ci-dessus parce que n&rsquo;ayant pas les caract&eacute;ristiques des langues r&eacute;gionales (de citoyennet&eacute; et/ou de territorialisation) ou appartenant &agrave; une autre r&eacute;gion. Il convient cependant de mentionner quelques langues dont la pr&eacute;sence est importante ou significative (et peut en particulier constituer un &eacute;l&eacute;ment de r&eacute;flexion &agrave; l&rsquo;Education nationale pour la scolarisation des non-francophones).</p>

<p><strong>Cr&eacute;oles de la Guadeloupe et de la Martinique</strong><br />
Ce sont des cr&eacute;oles fran&ccedil;ais, tr&egrave;s proches du cr&eacute;ole guyanais (voir fiche sur cette langue), parl&eacute;s par environ 7 000 Fran&ccedil;ais originaires des Antilles.</p>

<p><strong>Cr&eacute;ole ha&iuml;tien</strong><br />
Le cr&eacute;ole ha&iuml;tien appartient &agrave; la famille des cr&eacute;oles fran&ccedil;ais d&rsquo;Am&eacute;rique, mais pr&eacute;sente des diff&eacute;rences plus fortes avec les cr&eacute;oles des DOM fran&ccedil;ais que ces derniers entre eux. Les Ha&iuml;tiens constituent probablement la nationalit&eacute; &eacute;trang&egrave;re la plus nombreuse en Guyane (certaines estimations avancent un chiffre de 30 000 personnes).</p>

<p><strong>Portugais du Br&eacute;sil</strong><br />
Langue romane (branche ib&eacute;ro-romane &agrave; laquelle appartient aussi l&rsquo;espagnol). Elle est parl&eacute;e par l&rsquo;importante immigration br&eacute;silienne (environ 15 000 &agrave; 18 000 personnes&nbsp;?).</p>

<p><strong>Espagnol</strong><br />
Langue romane (branche ib&eacute;ro-romane) parl&eacute;e sous diverses vari&eacute;t&eacute;s sud-am&eacute;ricaines par un nombre non estim&eacute; d&rsquo;immigr&eacute;s de pays du continent, les P&eacute;ruviens et les Dominicains devant &ecirc;tre les plus nombreux.</p>

<p><strong>Sranan tongo</strong><br />
Dit aussi cr&eacute;ole surinamien (ou surinamais), il occupe au Surinam une place semblable &agrave; celle du cr&eacute;ole guyanais en Guyane. C&rsquo;est un cr&eacute;ole &agrave; base anglaise (comme les cr&eacute;oles dits businenge parl&eacute;s en Guyane et au Surinam). Il pr&eacute;sente cependant un certain nombre de particularit&eacute;s phonologiques (par exemple&nbsp;: maintien de la consonne /r/ dans de nombreux contextes) et lexicales (importance du vocabulaire d&rsquo;origine n&eacute;erlandaise). On ne poss&egrave;de pas de donn&eacute;es d&eacute;mographiques sur la population de langue sranan.</p>

<p><strong>Chinois</strong><br />
La population d&rsquo;origine chinoise compterait environ 7 000 personnes, pour la plupart originaire de Chine du Sud et de langue hakka. Il faut en effet savoir que ce qu&rsquo;on appelle chinois recouvre en r&eacute;alit&eacute; des langues parfois aussi diff&eacute;rentes entre elles que par exemple le fran&ccedil;ais et le portugais. Dans l&rsquo;usage habituel, lorsque aucun qualificatif particulier n&rsquo;est accol&eacute;, chinois (par exemple, dans &ldquo;dictionnaire chinois-fran&ccedil;ais&rdquo;, &ldquo;cours de chinois&rdquo;, &ldquo;grammaire chinoise&rdquo;) d&eacute;signe le chinois &quot;officiel&quot; ou chinois &quot;mandarin&quot; ou &quot;p&eacute;kinois&quot; parl&eacute; en Chine du Nord. Ce chinois mandarin joue le r&ocirc;le d&rsquo;une langue de prestige, connu de la plupart des Chinois, et enseign&eacute; en Guyane par l&rsquo;Association culturelle chinoise. Mais comme il a &eacute;t&eacute; dit plus haut, la tr&egrave;s grande majorit&eacute; des Chinois de Guyane sont de langue hakka. De moindre importance sont le cantonais, le dialecte du Zhejiang et le dialecte minnan.</p>

<p><strong>Lao</strong><br />
Environ 150 &agrave; 200 personnes d&rsquo;origine laotienne au village de Dacca (commune de Roura) et &agrave; Kourou. Il faut aussi ajouter que les Hmong de Guyane sont d&rsquo;origine laotienne et connaissent g&eacute;n&eacute;ralement la langue lao.</p>

<p><strong>Autres</strong><br />
De nombreuses autres langues sont parl&eacute;es par des groupes moins importants C&rsquo;est le cas en particulier de l&rsquo;arabe libanais, de l&rsquo;indon&eacute;sien (dialecte javanais), du hindi, du vietnamien, de l&rsquo;anglais r&eacute;gional et du cr&eacute;ole anglais du Guyana, du n&eacute;erlandais, du cr&eacute;ole (fran&ccedil;ais) de Sainte Lucie.</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['left'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 1,
    'link_to_view' => 0,
    'args' => '13',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues de Guyane',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['right'][0] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues_de_guyane__test';
  $handler->task = 'page';
  $handler->subtask = 'langues_de_guyane';
  $handler->handler = 'panel_context';
  $handler->weight = 1;
  $handler->conf = array(
    'title' => 'test',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_de_france',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Terme de taxonomie',
        'keyword' => 'taxonomy_term',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '7',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => 'test',
  );
  $display = new panels_display();
  $display->layout = 'onecol';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => NULL,
    ),
  );
  $display->cache = array();
  $display->title = 'Langues de Guyane';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues_de_guyane__test';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte langues de Guyane',
    'title' => '',
    'body' => '<p>La Guyane fran&ccedil;aise offre un cas typique de grand plurilinguisme pour une population restreinte (&eacute;valu&eacute;e &agrave; 170 000 personnes). Outre le fran&ccedil;ais, langue officielle, sont parl&eacute;es des langues de migrants - donc langues &eacute;trang&egrave;res - mais aussi une dizaine de langues qui pr&eacute;sentent les caract&eacute;ristiques des langues r&eacute;gionales (citoyennet&eacute;&nbsp;: elles sont parl&eacute;es par des citoyens fran&ccedil;ais, et territorialisation&nbsp;: elles sont parl&eacute;es dans des zones identifiables du territoire fran&ccedil;ais). Elles seront pr&eacute;sent&eacute;es en quatre groupes&nbsp;:</p>

<p>-&nbsp; le&nbsp;<a href="/spip.php?article49">Cr&eacute;ole guyanais</a><br />
-&nbsp; les langues am&eacute;rindiennes&nbsp;<br />
-&nbsp; les cr&eacute;oles noirs marrons (ou langues businenge)<br />
-&nbsp; le&nbsp;<a href="/spip.php?article58">hmong</a></p>

<p>Chacun de ces groupes de langues, voire chaque langue au sein d&rsquo;un groupe, pose des probl&egrave;mes sp&eacute;cifiques qui peuvent n&eacute;cessiter une approche diversifi&eacute;e (selon le chiffre de population, la zone g&eacute;ographique, le statut social des locuteurs ou le niveau d&rsquo;alt&eacute;rit&eacute; proprement linguistique de la langue). On donnera donc un certain nombre d&rsquo;indications d&rsquo;ordre linguistique et sociolinguistique &agrave; propos de chacune de ces langues.</p>

<p>En l&rsquo;absence de statistique officielle qui serait issue d&rsquo;une enqu&ecirc;te rigoureusement men&eacute;e sur les langues parl&eacute;es en territoire fran&ccedil;ais, le nombre de locuteurs est de toutes ces donn&eacute;es celle qui peut pr&ecirc;ter le plus &agrave; controverse. On sait d&rsquo;autre part que l&agrave; o&ugrave; une partie importante des locuteurs d&rsquo;une langue est en train de l&rsquo;abandonner au profit d&rsquo;une autre (dans le cas de la Guyane, essentiellement le fran&ccedil;ais ou le cr&eacute;ole), la notion de locuteur d&rsquo;une langue peut devenir floue. On est donc dans une situation mouvante, ce qui explique que les estimations ant&eacute;rieures varient souvent du simple au double. Les chiffres cit&eacute;s ici refl&egrave;teront cette prudence. On mentionnera cependant dans plusieurs cas les chiffres en g&eacute;n&eacute;ral assez pr&eacute;cis correspondant &agrave; un recensement effectu&eacute; il y a quelques ann&eacute;es par Fran&ccedil;oise et Pierre Grenand, ainsi que celui effectu&eacute; r&eacute;cemment par R&amp;S.Price (2002) pour les Noirs Marrons. Pour les pays voisins, on s&rsquo;est appuy&eacute; sur les donn&eacute;es figurant dans l&rsquo;ouvrage As l&iacute;nguas amaz&ocirc;nicas hoje, F. Queixal&oacute;s et O. Renault-Lescure (&eacute;ds.), IRD-ISA-MPEG, S&atilde;o Paulo, publi&eacute; en 2000.</p>

<h3>Les langues am&eacute;rindiennes</h3>

<p>Ce sont les langues autochtones au sens strict, parl&eacute;es par les premiers habitants du pays. Elles sont au nombre de six, r&eacute;parties entre trois des grandes familles linguistiques de l&rsquo;Am&eacute;rique du Sud.</p>

<p><strong>Famille caribe</strong></p>

<p>(ou karib, on trouve aussi cariban en anglais). En Guyane, les deux langues appartenant &agrave; cette famille sont le kali&rsquo;na et le wayana. La famille caribe comprend une trentaine de langues parl&eacute;es dans les pays du Nord de l&rsquo;Am&eacute;rique du Sud, autour de l&rsquo;Amazone. Dans le Nord du bassin amazonien, elles s&rsquo;&eacute;tendent jusqu&rsquo;&agrave; la c&ocirc;te&nbsp;; dans le Sud, elles vont jusqu&rsquo;&agrave; la haute vall&eacute;e du Xingu. Les plus occidentales de ces langues sont le carijona (Colombie) et le yukpa (Colombie et Venezuela)<br />
N.B. La langue dite cara&iuml;be (insulaire) qui &eacute;tait parl&eacute;e aux Petites Antilles au XVIIe si&egrave;cle (et d&eacute;crite dans le Dictionnaire Cara&iuml;be du P. Breton de 1665) est en fait une langue de base arawak (v. &agrave; arawak), mais avec une tr&egrave;s forte influence caribe dans le vocabulaire.</p>

<p><strong>Famille arawak</strong></p>

<p>En Guyane, cette famille est repr&eacute;sent&eacute;e par l&rsquo;arawak (proprement dit), appel&eacute; aussi lokono, et par le palikur. La famille arawak (qu&rsquo;il ne faut pas confondre avec la langue arawak &ldquo;proprement dite&rdquo; ou lokono) comprend une trentaine de langues parl&eacute;es sur la c&ocirc;te Nord de l&rsquo;Am&eacute;rique du Sud (la plus importante &eacute;tant le wayuu ou guajiro de la fronti&egrave;re Colombie-Venezuela), dans la zone amazonienne (P&eacute;rou, Br&eacute;sil, Bolivie) et jusqu&rsquo;en Am&eacute;rique Centrale (le garifuna, dit aussi Black Carib, parl&eacute; au Belize, au Honduras, au Guatemala et dans une importante diaspora aux Etats-Unis&nbsp;: cette langue est une &eacute;volution du Cara&iuml;be insulaire, v. ci-dessus &agrave; caribe).</p>

<p><strong>Famille tupi-guarani</strong></p>

<p>Deux langues de cette famille sont parl&eacute;es en Guyane&nbsp;: le wayampi et l&rsquo;&eacute;m&eacute;rillon. La Guyane repr&eacute;sente l&rsquo;extension la plus septentrionale de cette famille linguistique tr&egrave;s pr&eacute;sente dans le bassin amazonien (36 langues) et qui s&rsquo;&eacute;tend au Sud jusqu&rsquo;en Argentine. La principale langue de la famille est le guarani, parl&eacute; par plusieurs millions de personnes au Paraguay, en Argentine et au Br&eacute;sil, et actuellement officialis&eacute; au Paraguay&nbsp;; une autre langue tr&egrave;s voisine &eacute;tait au XVIIe si&egrave;cle la langue v&eacute;hiculaire (lingua geral) dans tout le Br&eacute;sil colonial.</p>

<p><strong>Voir aussi&nbsp;:</strong></p>

<p><a href="/spip.php?article50">Kali&rsquo;na</a>&nbsp;<br />
<a href="/spip.php?article51">Wayana</a></p>

<p><a href="/spip.php?article52">Arawak</a>&nbsp;<br />
<a href="/spip.php?article53">Palikur</a></p>

<p><a href="/spip.php?article54">Wayampi</a>&nbsp;<br />
<a href="/spip.php?article55">&Eacute;m&eacute;rillon</a></p>

<h3>Les langues businenge ou cr&eacute;oles noirs marrons, g&eacute;n&eacute;ralit&eacute;s</h3>

<p>Le groupe des langues cr&eacute;oles de base anglaise de Guyane et du Surinam</p>

<p><strong>R&eacute;partition linguistique</strong></p>

<p>Ce groupe de langues cr&eacute;oles rassemble 7 variantes linguistiques dont 5 sont repr&eacute;sent&eacute;es en Guyane fran&ccedil;aise&nbsp;: l&rsquo;aluku, le ndjuka, le paramaka, le saramaka (qui peuvent pr&eacute;tendre au statut de langues r&eacute;gionales), et le sranan tongo, langue v&eacute;hiculaire utilis&eacute;e notamment le long du fleuve Maroni. Les deux autres formes linguistiques de ce groupe sont le kwinti et le matawai, parl&eacute;s exclusivement au Surinam. Du point de vue linguistique, on distingue deux sous-groupes&nbsp;:<br />
-&nbsp;cr&eacute;oles de base dominante anglaise&nbsp;: aluku, ndjuka, paramaka, sranan tongo (ainsi que le kwinti du Surinam)<br />
-&nbsp;cr&eacute;oles de base anglaise relexifi&eacute;s &agrave; partir du portugais&nbsp;: saramaka (ainsi que le matawai du Surinam).</p>

<p><strong>R&eacute;partition sociolinguistique</strong></p>

<p>Ces langues correspondent &agrave; des usages et des groupes tr&egrave;s diff&eacute;renci&eacute;s sociologiquement. On distingue l&agrave; encore deux sous-groupes qui ne recouvrent pas les sous-groupes linguistiques&nbsp;:<br />
-&nbsp;le sranan tongo&nbsp;: &agrave; l&rsquo;origine langue des Cr&eacute;oles du Surinam, elle est la langue v&eacute;hiculaire la plus r&eacute;pandue de ce pays, et sert &eacute;galement de v&eacute;hiculaire dans l&rsquo;Ouest guyanais (r&eacute;gion de Saint Laurent). Elle est utilis&eacute;e dans les &eacute;changes extra-communautaires (entre Noirs Marrons et Am&eacute;rindiens&nbsp;; entre Noirs Marrons et Cr&eacute;oles guyanais&nbsp;; entre Noirs marrons et m&eacute;tropolitains)<br />
-&nbsp;les langues des Noirs Marrons (appel&eacute;es aussi langues businenge ou bushinenge)&nbsp;: il s&rsquo;agit de langues parl&eacute;es par les descendants des Marrons qui, d&egrave;s le d&eacute;but du syst&egrave;me esclavagiste, se sont enfuis des plantations (voir le panorama historique pour plus de d&eacute;tails)&nbsp;: ce sont tous les autres parlers cit&eacute;s.</p>

<p><strong>A propos du &quot;taki-taki&quot;</strong></p>

<p>Le terme taki-taki, tr&egrave;s couramment utilis&eacute;, est pourtant &agrave; &eacute;viter pour deux raisons&nbsp;: 1. il est d&eacute;pr&eacute;ciatif et surtout 2. il est ambigu, puisqu&rsquo;il peut d&eacute;signer alternativement n&rsquo;importe lequel des parlers businenge, mais aussi le sranan-tongo, ou une variante de &lsquo;sranan tongo langue &eacute;trang&egrave;re&rsquo; qui se d&eacute;veloppe &agrave; Saint-Laurent chez les populations non businenge.</p>

<p><strong>Voir aussi&nbsp;:</strong></p>

<p><a href="/spip.php?article56">Aluku, ndjuka, paramaka</a></p>

<p><a href="/spip.php?article57">Saramaka</a></p>

<h3>Autres langues parl&eacute;es en Guyane</h3>

<p>La Guyane &eacute;tant terre d&rsquo;immigration, de tr&egrave;s nombreux &eacute;trangers, Fran&ccedil;ais d&rsquo;origine &eacute;trang&egrave;re, voire Fran&ccedil;ais d&rsquo;autres DOM-TOM, peuvent parler des langues non cit&eacute;es ci-dessus parce que n&rsquo;ayant pas les caract&eacute;ristiques des langues r&eacute;gionales (de citoyennet&eacute; et/ou de territorialisation) ou appartenant &agrave; une autre r&eacute;gion. Il convient cependant de mentionner quelques langues dont la pr&eacute;sence est importante ou significative (et peut en particulier constituer un &eacute;l&eacute;ment de r&eacute;flexion &agrave; l&rsquo;Education nationale pour la scolarisation des non-francophones).</p>

<p><strong>Cr&eacute;oles de la Guadeloupe et de la Martinique</strong><br />
Ce sont des cr&eacute;oles fran&ccedil;ais, tr&egrave;s proches du cr&eacute;ole guyanais (voir fiche sur cette langue), parl&eacute;s par environ 7 000 Fran&ccedil;ais originaires des Antilles.</p>

<p><strong>Cr&eacute;ole ha&iuml;tien</strong><br />
Le cr&eacute;ole ha&iuml;tien appartient &agrave; la famille des cr&eacute;oles fran&ccedil;ais d&rsquo;Am&eacute;rique, mais pr&eacute;sente des diff&eacute;rences plus fortes avec les cr&eacute;oles des DOM fran&ccedil;ais que ces derniers entre eux. Les Ha&iuml;tiens constituent probablement la nationalit&eacute; &eacute;trang&egrave;re la plus nombreuse en Guyane (certaines estimations avancent un chiffre de 30 000 personnes).</p>

<p><strong>Portugais du Br&eacute;sil</strong><br />
Langue romane (branche ib&eacute;ro-romane &agrave; laquelle appartient aussi l&rsquo;espagnol). Elle est parl&eacute;e par l&rsquo;importante immigration br&eacute;silienne (environ 15 000 &agrave; 18 000 personnes&nbsp;?).</p>

<p><strong>Espagnol</strong><br />
Langue romane (branche ib&eacute;ro-romane) parl&eacute;e sous diverses vari&eacute;t&eacute;s sud-am&eacute;ricaines par un nombre non estim&eacute; d&rsquo;immigr&eacute;s de pays du continent, les P&eacute;ruviens et les Dominicains devant &ecirc;tre les plus nombreux.</p>

<p><strong>Sranan tongo</strong><br />
Dit aussi cr&eacute;ole surinamien (ou surinamais), il occupe au Surinam une place semblable &agrave; celle du cr&eacute;ole guyanais en Guyane. C&rsquo;est un cr&eacute;ole &agrave; base anglaise (comme les cr&eacute;oles dits businenge parl&eacute;s en Guyane et au Surinam). Il pr&eacute;sente cependant un certain nombre de particularit&eacute;s phonologiques (par exemple&nbsp;: maintien de la consonne /r/ dans de nombreux contextes) et lexicales (importance du vocabulaire d&rsquo;origine n&eacute;erlandaise). On ne poss&egrave;de pas de donn&eacute;es d&eacute;mographiques sur la population de langue sranan.</p>

<p><strong>Chinois</strong><br />
La population d&rsquo;origine chinoise compterait environ 7 000 personnes, pour la plupart originaire de Chine du Sud et de langue hakka. Il faut en effet savoir que ce qu&rsquo;on appelle chinois recouvre en r&eacute;alit&eacute; des langues parfois aussi diff&eacute;rentes entre elles que par exemple le fran&ccedil;ais et le portugais. Dans l&rsquo;usage habituel, lorsque aucun qualificatif particulier n&rsquo;est accol&eacute;, chinois (par exemple, dans &ldquo;dictionnaire chinois-fran&ccedil;ais&rdquo;, &ldquo;cours de chinois&rdquo;, &ldquo;grammaire chinoise&rdquo;) d&eacute;signe le chinois &quot;officiel&quot; ou chinois &quot;mandarin&quot; ou &quot;p&eacute;kinois&quot; parl&eacute; en Chine du Nord. Ce chinois mandarin joue le r&ocirc;le d&rsquo;une langue de prestige, connu de la plupart des Chinois, et enseign&eacute; en Guyane par l&rsquo;Association culturelle chinoise. Mais comme il a &eacute;t&eacute; dit plus haut, la tr&egrave;s grande majorit&eacute; des Chinois de Guyane sont de langue hakka. De moindre importance sont le cantonais, le dialecte du Zhejiang et le dialecte minnan.</p>

<p><strong>Lao</strong><br />
Environ 150 &agrave; 200 personnes d&rsquo;origine laotienne au village de Dacca (commune de Roura) et &agrave; Kourou. Il faut aussi ajouter que les Hmong de Guyane sont d&rsquo;origine laotienne et connaissent g&eacute;n&eacute;ralement la langue lao.</p>

<p><strong>Autres</strong><br />
De nombreuses autres langues sont parl&eacute;es par des groupes moins importants C&rsquo;est le cas en particulier de l&rsquo;arabe libanais, de l&rsquo;indon&eacute;sien (dialecte javanais), du hindi, du vietnamien, de l&rsquo;anglais r&eacute;gional et du cr&eacute;ole anglais du Guyana, du n&eacute;erlandais, du cr&eacute;ole (fran&ccedil;ais) de Sainte Lucie.</p>
',
    'format' => 'full_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['middle'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 1,
    'link_to_view' => 0,
    'args' => '13',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues de Guyane',
    'override_title_heading' => 'h2',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 1;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['middle'][1] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['langues_de_guyane'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'langues_de_mayotte';
  $page->task = 'page';
  $page->admin_title = 'Langues de Mayotte';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-de-mayotte';
  $page->access = array();
  $page->menu = array(
    'type' => 'none',
    'title' => 'Langues de Mayotte',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues_de_mayotte__panel_context_6f103a63-bc47-4961-ba07-199f2d50e9ba';
  $handler->task = 'page';
  $handler->subtask = 'langues_de_mayotte';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Langues de Mayotte',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_de_mayotte',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Mayotte',
        'keyword' => 'taxonomy_term_mayotte',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '11',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => '',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => NULL,
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Langues de Mayotte';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues_de_mayotte__panel_context_6f103a63-bc47-4961-ba07-199f2d50e9ba';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte langues de Mayotte',
    'title' => '',
    'body' => '<p><strong>Introduction</strong></p>

<p>Mayotte est l&rsquo;&icirc;le la plus m&eacute;ridionale de l&rsquo;archipel des Comores, dans l&rsquo;oc&eacute;an indien, entre Madagascar et la c&ocirc;te orientale de l&rsquo;Afrique, &agrave; la latitude du Nord du Mozambique. Elle est compos&eacute;e de la Grande-Terre s&eacute;par&eacute;e par un bras de mer de 4 km de la Petite-Terre &agrave; laquelle est rattach&eacute; le rocher de Dzaoudzi.</p>

<p>Alors que les trois autres &icirc;les de l&rsquo;archipel, Grande-Comore (Ngazidja), Moh&eacute;li (Mwali), Anjouan (Ndzuani), sont devenues ind&eacute;pendantes en 1975, Mayotte (Maore) est rest&eacute;e sous administration fran&ccedil;aise. Les raisons politiques qui expliquent cette divergence de choix entre les &icirc;les ne doivent pas pour autant faire oublier que, sur un plan culturel et linguistique, Mayotte fait partie du m&ecirc;me ensemble que les trois autres &icirc;les.</p>

<p>Sur un plan culturel, ces quatre &icirc;les appartiennent, comme les r&eacute;gions c&ocirc;ti&egrave;res du Sud de la Somalie jusqu&rsquo;au Nord du Mozambique, &agrave; l&rsquo;aire culturelle swahili qui se caract&eacute;rise par des apports arabes et une tr&egrave;s forte impr&eacute;gnation de l&rsquo;Islam sur un fond africain.</p>

<p>Il &eacute;tait commun&eacute;ment admis, jusqu&rsquo;en 1975, date des premi&egrave;res missions linguistiques aux Comores, que les parlers comoriens &eacute;taient des dialectes du swahili. Ce jugement rapide se fondait sur la constatation que, en swahili comme en comorien, le lexique emprunte de nombreux termes &agrave; l&rsquo;arabe classique et aux parlers de la p&eacute;ninsule arabique (environ 40% du lexique).</p>

<p>Ces emprunts se sont effectu&eacute;s directement ou par l&rsquo;interm&eacute;diaire du swahili&nbsp;:</p>

<p>-&nbsp;Au XVI&egrave;me si&egrave;cle, une vague de colonisation en provenance d&rsquo;Oman et du golfe arabo-persique (d&eacute;sign&eacute;e comme les &quot;Shirazi&quot;) a atteint les Comores, peut-&ecirc;tre sous forme d&rsquo;installations directes mais probablement davantage sous formes de mouvements successifs via les villes arabis&eacute;es de la c&ocirc;te orientale d&rsquo;Afrique,<br />
-&nbsp;Ult&eacute;rieurement, au XVIII et XIX&egrave;me si&egrave;cles, le parler de Zanzibar, qui devait devenir ensuite la base du swahili standard, a &eacute;t&eacute; la langue commune de la diplomatie et du commerce dans toute la r&eacute;gion.</p>

<p>Une analyse plus pouss&eacute;e des structures des langues comoriennes montre que nous avons aujourd&rsquo;hui une langue &agrave; part enti&egrave;re, bien distincte du swahili et divis&eacute;e en deux sous-groupes, grand comorien (ngazidja) et moh&eacute;lien (mwali), d&rsquo;une part, et anjouanais (ndzuani) et mahorais (maore) de l&rsquo;autre. Il n&rsquo;y a aucune intercompr&eacute;hension entre les parlers comoriens et le swahili, qu&rsquo;il soit standard ou dialectal, tandis qu&rsquo;il y a intercompr&eacute;hension entre les parlers comoriens. Ce sont des langues bantoues. Le terme bantu (francis&eacute; dans la suite du texte sous la forme &ldquo;bantou&rdquo;) d&eacute;signe un ensemble de plus de 300 langues qui constitue le groupe linguistique le plus important d&rsquo;Afrique sub-saharienne (du Cameroun au Cap et d&rsquo;un oc&eacute;an &agrave; l&rsquo;autre). Ces langues se caract&eacute;risent par une tr&egrave;s grande homog&eacute;n&eacute;it&eacute; de structure, homog&eacute;n&eacute;it&eacute; comparable &agrave; celle des langues romanes.</p>

<p>Il faut enfin pr&eacute;ciser qu&rsquo;une minorit&eacute; des Mahorais a pour langue maternelle un parler malgache appel&eacute; dans cette langue&nbsp;:&nbsp;<em>kibushi</em>&nbsp;ou encore<em>kibushi kimaore</em>&nbsp;[<a href="#nb1" id="nh1" rel="footnote" title="Kiboŝi kimaôre en orthographe malgache.">1</a>]&nbsp;, c&rsquo;est &agrave; dire &ldquo;malgache de Mayotte&rdquo;,&nbsp;<em>shibushi</em>&nbsp;[<a href="#nb2" id="nh2" rel="footnote" title="Ce qui signifie tout simplement : langue malgache.">2</a>]&nbsp;en mahorais. Ces villages (une vingtaine) de langue malgache sont dispers&eacute;s dans toute l&rsquo;&icirc;le et ne constituent pas une r&eacute;gion particuli&egrave;re de Mayotte. Les Mahorais malgachophones parlent &eacute;galement mahorais alors que la r&eacute;ciproque n&rsquo;est pas vraie. Cette diff&eacute;rence est uniquement linguistique et l&rsquo;homog&eacute;n&eacute;it&eacute; culturelle est tr&egrave;s forte, avec des modes de vie, des valeurs et des croyances identiques toujours tr&egrave;s marqu&eacute;s par l&rsquo;Islam.</p>

<p>Cette langue, comme les autres parlers de Madagascar, se rattache &agrave; la famille des langues austron&eacute;siennes parl&eacute;es essentiellement en Indon&eacute;sie et dans les &icirc;les du Pacifique. Cette famille de langue n&rsquo;a rien &agrave; voir avec le grand ensemble africain des langues bantoues et Mayotte constitue donc, en quelque sorte, un des rares points de contact entre deux tr&egrave;s grandes zones linguistiques s&eacute;par&eacute;es, ailleurs, par des milliers de kilom&egrave;tres d&rsquo;oc&eacute;an. Pour plus d&rsquo;information sur ce parler malgache de Mayotte, minorit&eacute; &agrave; l&rsquo;int&eacute;rieur d&rsquo;une minorit&eacute;, voir les travaux de No&euml;l Gueunier.</p>

<p><strong>Histoire linguistique et situation actuelle</strong></p>

<p>Le mahorais (dans la langue&nbsp;: maore), est une langue &agrave; tradition orale&nbsp;; son histoire est donc tr&egrave;s difficile &agrave; reconstruire. L&rsquo;utilisation de l&rsquo;&eacute;criture en graphie arabe est ancienne &agrave; Mayotte, mais cette alphab&eacute;tisation a servi essentiellement &agrave; la lecture du Coran ou d&rsquo;ouvrages religieux ou juridiques en langue arabe. Les Mahorais ont eu &eacute;galement recours &agrave; la graphie arabe pour &eacute;tablir des documents diplomatiques ou commerciaux mais ceux-ci ont &eacute;t&eacute; souvent r&eacute;dig&eacute;s en swahili, la langue de communication de la r&eacute;gion entre les XII&egrave;me et XVIII&egrave;me si&egrave;cles. Nous n&rsquo;avons pratiquement aucun document &eacute;crit ancien qui nous permette de retracer une histoire de l&rsquo;&eacute;volution de la langue. Les traditions orales sont, en revanche, encore tr&egrave;s vivantes et elles constituent un corpus consid&eacute;rable de contes dans lesquels on retrouve des th&egrave;mes africains et des th&egrave;mes du monde arabe. On y trouve m&ecirc;me parfois, dans des parties chant&eacute;es, des formules magiques, incompr&eacute;hensibles aux Mahorais aujourd&rsquo;hui, qui sont en fait du makua, langue parl&eacute;e au nord du Mozambique, ce qui montre que les contacts ont &eacute;t&eacute; complexes entre Mayotte et la c&ocirc;te africaine (apports tr&egrave;s anciens puis apports plus r&eacute;cents li&eacute;s &agrave; la traite des esclaves dans l&rsquo;oc&eacute;an indien &agrave; l&rsquo;&eacute;poque moderne).</p>

<p>Mayotte a une population d&rsquo;environ 150 000 habitants et l&rsquo;aire d&rsquo;extension du mahorais se confond avec la surface de l&rsquo;&icirc;le. Il y a bien, en effet, une &eacute;migration comorienne importante et assez ancienne vers Madagascar (Majunga), La R&eacute;union et la France m&eacute;tropolitaine (en particulier &agrave; Marseille, quartier de l&rsquo;h&ocirc;tel Louvois) li&eacute;e aux emplois de Comoriens dans la marine marchande. Mais cette &eacute;migration a surtout &eacute;t&eacute; le fait des Grand-Comoriens et des Anjouanais qui ont quitt&eacute; des &icirc;les plus dens&eacute;ment peupl&eacute;es. A l&rsquo;int&eacute;rieur de cette &eacute;migration, le pourcentage d&rsquo;Anjouanais au parler tr&egrave;s proche du mahorais est important, mais la proportion de Mahorais est tr&egrave;s marginale.</p>

<p>D&rsquo;apr&egrave;s le recensement de 1991, 65 &agrave; 70&nbsp;% de la population de Mayotte ne maitrisait pas, ou maitrisait mal, le fran&ccedil;ais &agrave; cette date. On estime qu&rsquo;aujourd&rsquo;hui ce pourcentage serait d&rsquo;environ 60&nbsp;%. Mis &agrave; part quelques fonctionnaires d&rsquo;origine m&eacute;tropolitaine, il n&rsquo;existe pas de francophones monolingues &agrave; Mayotte.</p>

<p>Marie-Fran&ccedil;oise ROMBI (CNRS, LACITO)</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['left'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues de Mayotte',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['right'][0] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['langues_de_mayotte'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'langues_de_polyn_sie';
  $page->task = 'page';
  $page->admin_title = 'Langues de Polynésie';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-de-polynesie';
  $page->access = array();
  $page->menu = array(
    'type' => 'none',
    'title' => 'Langues de Polynésie',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues_de_polyn_sie__panel_context_7b0d9dbf-a8ce-4e83-a732-a4ae4a8371be';
  $handler->task = 'page';
  $handler->subtask = 'langues_de_polyn_sie';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Langues de Polynésie',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_de_polynesie',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Polynesie Francaise',
        'keyword' => 'taxonomy_term_polynesie_francaise',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '8',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => '',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '7',
          'sm' => '7',
          'md' => '7',
          'lg' => '7',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'top' => NULL,
      'bottom' => NULL,
    ),
    'middle' => array(
      'style' => 'bootstrap_region',
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Langues de Polynésie';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues_de_polyn_sie__panel_context_7b0d9dbf-a8ce-4e83-a732-a4ae4a8371be';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte langues de Polynésie',
    'title' => '',
    'body' => '<p><strong>Introduction</strong></p>

<p>Mayotte est l&rsquo;&icirc;le la plus m&eacute;ridionale de l&rsquo;archipel des Comores, dans l&rsquo;oc&eacute;an indien, entre Madagascar et la c&ocirc;te orientale de l&rsquo;Afrique, &agrave; la latitude du Nord du Mozambique. Elle est compos&eacute;e de la Grande-Terre s&eacute;par&eacute;e par un bras de mer de 4 km de la Petite-Terre &agrave; laquelle est rattach&eacute; le rocher de Dzaoudzi.</p>

<p>Alors que les trois autres &icirc;les de l&rsquo;archipel, Grande-Comore (Ngazidja), Moh&eacute;li (Mwali), Anjouan (Ndzuani), sont devenues ind&eacute;pendantes en 1975, Mayotte (Maore) est rest&eacute;e sous administration fran&ccedil;aise. Les raisons politiques qui expliquent cette divergence de choix entre les &icirc;les ne doivent pas pour autant faire oublier que, sur un plan culturel et linguistique, Mayotte fait partie du m&ecirc;me ensemble que les trois autres &icirc;les.</p>

<p>Sur un plan culturel, ces quatre &icirc;les appartiennent, comme les r&eacute;gions c&ocirc;ti&egrave;res du Sud de la Somalie jusqu&rsquo;au Nord du Mozambique, &agrave; l&rsquo;aire culturelle swahili qui se caract&eacute;rise par des apports arabes et une tr&egrave;s forte impr&eacute;gnation de l&rsquo;Islam sur un fond africain.</p>

<p>Il &eacute;tait commun&eacute;ment admis, jusqu&rsquo;en 1975, date des premi&egrave;res missions linguistiques aux Comores, que les parlers comoriens &eacute;taient des dialectes du swahili. Ce jugement rapide se fondait sur la constatation que, en swahili comme en comorien, le lexique emprunte de nombreux termes &agrave; l&rsquo;arabe classique et aux parlers de la p&eacute;ninsule arabique (environ 40% du lexique).</p>

<p>Ces emprunts se sont effectu&eacute;s directement ou par l&rsquo;interm&eacute;diaire du swahili&nbsp;:</p>

<p>-&nbsp;Au XVI&egrave;me si&egrave;cle, une vague de colonisation en provenance d&rsquo;Oman et du golfe arabo-persique (d&eacute;sign&eacute;e comme les &quot;Shirazi&quot;) a atteint les Comores, peut-&ecirc;tre sous forme d&rsquo;installations directes mais probablement davantage sous formes de mouvements successifs via les villes arabis&eacute;es de la c&ocirc;te orientale d&rsquo;Afrique,<br />
-&nbsp;Ult&eacute;rieurement, au XVIII et XIX&egrave;me si&egrave;cles, le parler de Zanzibar, qui devait devenir ensuite la base du swahili standard, a &eacute;t&eacute; la langue commune de la diplomatie et du commerce dans toute la r&eacute;gion.</p>

<p>Une analyse plus pouss&eacute;e des structures des langues comoriennes montre que nous avons aujourd&rsquo;hui une langue &agrave; part enti&egrave;re, bien distincte du swahili et divis&eacute;e en deux sous-groupes, grand comorien (ngazidja) et moh&eacute;lien (mwali), d&rsquo;une part, et anjouanais (ndzuani) et mahorais (maore) de l&rsquo;autre. Il n&rsquo;y a aucune intercompr&eacute;hension entre les parlers comoriens et le swahili, qu&rsquo;il soit standard ou dialectal, tandis qu&rsquo;il y a intercompr&eacute;hension entre les parlers comoriens. Ce sont des langues bantoues. Le terme bantu (francis&eacute; dans la suite du texte sous la forme &ldquo;bantou&rdquo;) d&eacute;signe un ensemble de plus de 300 langues qui constitue le groupe linguistique le plus important d&rsquo;Afrique sub-saharienne (du Cameroun au Cap et d&rsquo;un oc&eacute;an &agrave; l&rsquo;autre). Ces langues se caract&eacute;risent par une tr&egrave;s grande homog&eacute;n&eacute;it&eacute; de structure, homog&eacute;n&eacute;it&eacute; comparable &agrave; celle des langues romanes.</p>

<p>Il faut enfin pr&eacute;ciser qu&rsquo;une minorit&eacute; des Mahorais a pour langue maternelle un parler malgache appel&eacute; dans cette langue&nbsp;:&nbsp;<em>kibushi</em>&nbsp;ou encore<em>kibushi kimaore</em>&nbsp;[<a href="#nb1" id="nh1" rel="footnote" title="Kiboŝi kimaôre en orthographe malgache.">1</a>]&nbsp;, c&rsquo;est &agrave; dire &ldquo;malgache de Mayotte&rdquo;,&nbsp;<em>shibushi</em>&nbsp;[<a href="#nb2" id="nh2" rel="footnote" title="Ce qui signifie tout simplement : langue malgache.">2</a>]&nbsp;en mahorais. Ces villages (une vingtaine) de langue malgache sont dispers&eacute;s dans toute l&rsquo;&icirc;le et ne constituent pas une r&eacute;gion particuli&egrave;re de Mayotte. Les Mahorais malgachophones parlent &eacute;galement mahorais alors que la r&eacute;ciproque n&rsquo;est pas vraie. Cette diff&eacute;rence est uniquement linguistique et l&rsquo;homog&eacute;n&eacute;it&eacute; culturelle est tr&egrave;s forte, avec des modes de vie, des valeurs et des croyances identiques toujours tr&egrave;s marqu&eacute;s par l&rsquo;Islam.</p>

<p>Cette langue, comme les autres parlers de Madagascar, se rattache &agrave; la famille des langues austron&eacute;siennes parl&eacute;es essentiellement en Indon&eacute;sie et dans les &icirc;les du Pacifique. Cette famille de langue n&rsquo;a rien &agrave; voir avec le grand ensemble africain des langues bantoues et Mayotte constitue donc, en quelque sorte, un des rares points de contact entre deux tr&egrave;s grandes zones linguistiques s&eacute;par&eacute;es, ailleurs, par des milliers de kilom&egrave;tres d&rsquo;oc&eacute;an. Pour plus d&rsquo;information sur ce parler malgache de Mayotte, minorit&eacute; &agrave; l&rsquo;int&eacute;rieur d&rsquo;une minorit&eacute;, voir les travaux de No&euml;l Gueunier.</p>

<p><strong>Histoire linguistique et situation actuelle</strong></p>

<p>Le mahorais (dans la langue&nbsp;: maore), est une langue &agrave; tradition orale&nbsp;; son histoire est donc tr&egrave;s difficile &agrave; reconstruire. L&rsquo;utilisation de l&rsquo;&eacute;criture en graphie arabe est ancienne &agrave; Mayotte, mais cette alphab&eacute;tisation a servi essentiellement &agrave; la lecture du Coran ou d&rsquo;ouvrages religieux ou juridiques en langue arabe. Les Mahorais ont eu &eacute;galement recours &agrave; la graphie arabe pour &eacute;tablir des documents diplomatiques ou commerciaux mais ceux-ci ont &eacute;t&eacute; souvent r&eacute;dig&eacute;s en swahili, la langue de communication de la r&eacute;gion entre les XII&egrave;me et XVIII&egrave;me si&egrave;cles. Nous n&rsquo;avons pratiquement aucun document &eacute;crit ancien qui nous permette de retracer une histoire de l&rsquo;&eacute;volution de la langue. Les traditions orales sont, en revanche, encore tr&egrave;s vivantes et elles constituent un corpus consid&eacute;rable de contes dans lesquels on retrouve des th&egrave;mes africains et des th&egrave;mes du monde arabe. On y trouve m&ecirc;me parfois, dans des parties chant&eacute;es, des formules magiques, incompr&eacute;hensibles aux Mahorais aujourd&rsquo;hui, qui sont en fait du makua, langue parl&eacute;e au nord du Mozambique, ce qui montre que les contacts ont &eacute;t&eacute; complexes entre Mayotte et la c&ocirc;te africaine (apports tr&egrave;s anciens puis apports plus r&eacute;cents li&eacute;s &agrave; la traite des esclaves dans l&rsquo;oc&eacute;an indien &agrave; l&rsquo;&eacute;poque moderne).</p>

<p>Mayotte a une population d&rsquo;environ 150 000 habitants et l&rsquo;aire d&rsquo;extension du mahorais se confond avec la surface de l&rsquo;&icirc;le. Il y a bien, en effet, une &eacute;migration comorienne importante et assez ancienne vers Madagascar (Majunga), La R&eacute;union et la France m&eacute;tropolitaine (en particulier &agrave; Marseille, quartier de l&rsquo;h&ocirc;tel Louvois) li&eacute;e aux emplois de Comoriens dans la marine marchande. Mais cette &eacute;migration a surtout &eacute;t&eacute; le fait des Grand-Comoriens et des Anjouanais qui ont quitt&eacute; des &icirc;les plus dens&eacute;ment peupl&eacute;es. A l&rsquo;int&eacute;rieur de cette &eacute;migration, le pourcentage d&rsquo;Anjouanais au parler tr&egrave;s proche du mahorais est important, mais la proportion de Mahorais est tr&egrave;s marginale.</p>

<p>D&rsquo;apr&egrave;s le recensement de 1991, 65 &agrave; 70&nbsp;% de la population de Mayotte ne maitrisait pas, ou maitrisait mal, le fran&ccedil;ais &agrave; cette date. On estime qu&rsquo;aujourd&rsquo;hui ce pourcentage serait d&rsquo;environ 60&nbsp;%. Mis &agrave; part quelques fonctionnaires d&rsquo;origine m&eacute;tropolitaine, il n&rsquo;existe pas de francophones monolingues &agrave; Mayotte.</p>

<p>Marie-Fran&ccedil;oise ROMBI (CNRS, LACITO)</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['left'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues de Polynésie',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['right'][0] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['langues_de_polyn_sie'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'langues_non_territoriales';
  $page->task = 'page';
  $page->admin_title = 'Langues non territoriales';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-non-territoriales';
  $page->access = array();
  $page->menu = array(
    'type' => 'normal',
    'title' => 'Langues non-territoriales',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_langues_non_territoriales__panel_context_fc1d541a-35c9-48f9-977b-39840d6c7b51';
  $handler->task = 'page';
  $handler->subtask = 'langues_non_territoriales';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Langues non territoriales',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_non_territoriales',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Terme de taxonomie',
        'keyword' => 'taxonomy_term',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '5',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => '',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => NULL,
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Les langues non-territoriales';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_langues_non_territoriales__panel_context_fc1d541a-35c9-48f9-977b-39840d6c7b51';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte langues non-territoriales',
    'title' => '',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi.</p>

<p>Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem.</p>

<p>Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero. Fusce vulputate eleifend sapien. Vestibulum purus quam, scelerisque ut, mollis sed, nonummy id, metus. Nullam accumsan lorem in dui. Cras ultricies mi eu turpis hendrerit fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; In ac dui quis mi consectetuer lacinia. Nam pretium turpis et arcu. Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Sed aliquam ultrices mauris. Integer ante arcu, accumsan a, consectetuer eget, posuere ut, mauris. Praesent adipiscing. Phasellus ullamcorper ipsum rutrum nunc. Nunc nonummy metus. Vestibulum volutpat pretium libero. Cras id dui. Aenean ut</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['left'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues non-territoriales',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['right'][0] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['langues_non_territoriales'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'les_langues_kanaks';
  $page->task = 'page';
  $page->admin_title = 'Les langues kanaks';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-kanaks';
  $page->access = array();
  $page->menu = array(
    'type' => 'none',
    'title' => 'Langues kanaks',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_les_langues_kanaks__panel_context_c49b2bfd-0b52-497f-8693-4830c7969e59';
  $handler->task = 'page';
  $handler->subtask = 'les_langues_kanaks';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Langues kanaks',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_kanaks',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Nouvelle Caledonie',
        'keyword' => 'taxonomy_term_nouvelle_caledonie',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '10',
        'id' => 1,
      ),
    ),
    'relationships' => array(),
    'name' => '',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => NULL,
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'top' => NULL,
      'bottom' => NULL,
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Les langues kanaks';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_les_langues_kanaks__panel_context_c49b2bfd-0b52-497f-8693-4830c7969e59';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte Les langues kanaks',
    'title' => '',
    'body' => '<p>Toutes les langues kanak de Nouvelle-Cal&eacute;donie appartiennent au rameau oc&eacute;anien de la famille linguistique austron&eacute;sienne (Oc&eacute;anie, Insulinde et Ta&iuml;wan). Par contre elles sont sans relation linguistique avec les langues papoues de Nouvelle-Guin&eacute;e ou avec celles des aborig&egrave;nes d&rsquo;Australie.</p>

<p>Les langues kanak se r&eacute;partissent en deux grands groupes&nbsp;: celles de la Grande Terre et celles des Loyaut&eacute;.<br />
La plupart de ces petites langues pr&eacute;sentent des variations dialectales et se subdivisent encore en parlers souvent dot&eacute;s d&rsquo;un nom. La distinction entre langues et dialectes (ou parlers) n&rsquo;est pas toujours facile &agrave; faire et, de ce fait, le simple d&eacute;compte des langues n&eacute;o-cal&eacute;doniennes s&rsquo;av&egrave;re probl&eacute;matique.</p>

<p>Les langues kanak sont parl&eacute;es par de petites communaut&eacute;s li&eacute;es entre elles par de multiples relations matrimoniales ou politiques. Les locuteurs sont traditionnellement bilingues ou plurilingues&nbsp;: ils parlent ou comprennent la langue de leurs voisins, celle de leur famille maternelle en cas de mariage &agrave; l&rsquo;ext&eacute;rieur du groupe linguistique. On parle de plurilinguisme &eacute;galitaire pour souligner qu&rsquo;aucune langue particuli&egrave;re n&rsquo;&eacute;tait dot&eacute;e de prestige ou dans un rapport de domination avec les autres.&nbsp;<br />
Avec ces langues se perp&eacute;tuent les savoirs du monde kanak et la m&eacute;moire des diff&eacute;rents terroirs.</p>

<p><img alt="" src="http://mcc.dev:8890/sites/default/files/langues/ncal-map-lng.gif" style="height:420px; width:600px" /></p>

<p>Distribution g&eacute;ographique des langues<br />
Avec la cr&eacute;ation r&eacute;cente d&rsquo;un Conseil Consultatif Coutumier ont &eacute;t&eacute; constitu&eacute;es huit &laquo;&nbsp;Aires coutumi&egrave;res&nbsp;&raquo;&nbsp;: cinq sur la Grande Terre et trois aux Loyaut&eacute;. Chaque aire dispose d&rsquo;un Conseil qui peut d&eacute;lib&eacute;rer sur les probl&egrave;mes de langue et de culture. Les diff&eacute;rentes langues sont pr&eacute;sent&eacute;es dans le cadre de ces aires coutumi&egrave;res.</p>

<h3>Langues kanak de la Grande Terre&nbsp;:</h3>

<p><strong>Aire coutumi&egrave;re Hoot ma Waap</strong></p>

<p>14 000 locuteurs - onze langues&nbsp;: n&ecirc;l&ecirc;mwa/nixumwak, yuanga, nyel&acirc;yu, caac, jawe, fw&acirc;i, nemi, pije, pwaamei, pwapw&acirc;, langue de Voh-Kon&eacute; (six dialectes&nbsp;: bwatoo, haeke, haveke, hmwaveke, hmwaeke, vamale, (waamwang))</p>

<p>L&rsquo;aire coutumi&egrave;re Hoot ma Waap, situ&eacute;e au nord de la Grande Terre, est l&rsquo;aire coutumi&egrave;re la plus diversifi&eacute;e linguistiquement. Onze langues, dont certaines sont &agrave; leur tour subdivis&eacute;es en plusieurs dialectes, sont en effet parl&eacute;es dans cette r&eacute;gion. La langue la plus parl&eacute;e, celle de Gomen/Bond&eacute;, totalise 3 000 locuteurs. L&rsquo;aire Hoot ma Waap consiste donc en une mosa&iuml;que de petites communaut&eacute;s linguistiques, parfois de moins de cent personnes comme celle de langue pwapw&acirc;. L&rsquo;un des dialectes de la r&eacute;gion de Voh-Kon&eacute;, le waamwang, a disparu vers le milieu du si&egrave;cle dernier.</p>

<p><em>Remarques linguistiques</em></p>

<p>C&rsquo;est l&rsquo;aire des langues riches en consonnes, les plus riches de l&rsquo;ensemble n&eacute;o-cal&eacute;donien sinon de l&rsquo;ensemble oc&eacute;anien tout entier.&nbsp;<br />
Elles opposent consonnes simples/consonnes aspir&eacute;es (p/ph, m/hm, etc.). Certaines langues comme le nemi ont conserv&eacute; des consonnes postnasalis&eacute;es (pm, tn, cn, kn), v&eacute;ritables raret&eacute;s dans les langues du monde. Ces consonnes, qui &eacute;taient pr&eacute;sentes autrefois dans toutes les langues de cette r&eacute;gion, sont &agrave; l&rsquo;origine des voyelles nasales recens&eacute;es dans cette aire linguistique. Une langue comme le nemi totalise plus de quarante consonnes (cf. Ozanne-Rivierre, 1975).<br />
Contrairement aux langues du sud, les langues de cette r&eacute;gion ont des syst&egrave;mes vocaliques simples. Les timbres vocaliques les plus usuels sont a, e, i, o, u (brefs ou longs). Les voyelles centrales et les voyelles nasales ne sont que marginales dans ces syst&egrave;mes.<br />
L&rsquo;analyse des changements phonologiques survenus dans les langues du nord par rapport &agrave; l&rsquo;anc&ecirc;tre oc&eacute;anien et la reconstruction du syst&egrave;me proto-nord-cal&eacute;donien sont pr&eacute;sent&eacute;es dans un article de F. Ozanne-Rivierre, &laquo;&nbsp;<em>Structural changes in the languages of Northern New Caledonia</em>&nbsp;&raquo;,<em>&nbsp;Oceanic Linguistics</em>&nbsp;34, 1995, pp. 46-72.<br />
Sur le plan syntaxique, l&rsquo;ordre non marqu&eacute; des constituants place le verbe ou le pr&eacute;dicat en t&ecirc;te de l&rsquo;&eacute;nonc&eacute;. Les indices personnels sont int&eacute;gr&eacute;s dans le groupe verbal (sVo) (sujet-Verbe-objet). Les actants nominaux (agent, patient) sont postpos&eacute;s au pr&eacute;dicat. L&rsquo;ordre normal non marqu&eacute; est sV S (S = sujet nominal) si le verbe est intransitif et sV O A (O = objet nominal et A = agent nominal marqu&eacute; &agrave; l&rsquo;ergatif) si le verbe est transitif.</p>

<p><strong>Aire coutumi&egrave;re Paici-Camuki</strong></p>

<p>Avec un peu plus de onze mille locuteurs, &eacute;tablis en majorit&eacute; dans le centre nord de la Grande Terre, l&rsquo;aire paici-c&egrave;muh&icirc; est &agrave; peine moins peupl&eacute;e que l&rsquo;aire Hoot ma Waap qui la jouxte. Elle ne comptabilise cependant que les deux langues qui lui ont donn&eacute; son nom&nbsp;: le paic&icirc; et le c&egrave;muh&icirc; (contre onze langues dans l&rsquo;aire Hoot ma Waap). On est donc loin du morcellement linguistique propre au nord de la Grande Terre d&rsquo;autant que le paic&icirc;, comme le c&egrave;muh&icirc;, comporte peu de variantes dialectales. Organis&eacute;s selon un syst&egrave;me de moiti&eacute;s matrimoniales (les Dui et les Bai) qui a pu conforter leur dynamisme et leur unit&eacute;, les Paic&icirc; sont &agrave; pr&eacute;sent pr&egrave;s de huit mille et constituent la plus importante communaut&eacute; linguistique de la Grande Terre.</p>

<p>Malgr&eacute; son importance, le paic&icirc; a &eacute;t&eacute; &agrave; peu pr&egrave;s compl&egrave;tement d&eacute;laiss&eacute; par les missions alors que le c&egrave;muh&icirc; &eacute;tait &eacute;tudi&eacute; et pratiqu&eacute; par les Maristes pendant toute la seconde moiti&eacute; du dix-neuvi&egrave;me si&egrave;cle.</p>

<p>Sur le plan linguistique le paic&icirc; et le c&egrave;muh&icirc; forment un sous-groupe particulier au sein de l&rsquo;ensemble des langues du nord de la Grande Terre. Beaucoup plus pauvres en consonnes que ces derni&egrave;res, le paic&icirc; et le c&egrave;muh&icirc; pr&eacute;sentent la singularit&eacute; remarquable d&rsquo;&ecirc;tre deux langues tonales. Elles sont cependant bien diff&eacute;rentes l&rsquo;une de l&rsquo;autre, le paic&icirc; ayant &eacute;t&eacute; profond&eacute;ment influenc&eacute; dans son &eacute;volution par les langues du sud de la Grande Terre qui l&rsquo;avoisinent.</p>

<p><strong>Aire coutumi&egrave;re Ajie-Aro</strong></p>

<p>L&rsquo;aire coutumi&egrave;re Aji&euml;-Aro comprend six langues pour moins de sept mille locuteurs&nbsp;: aji&euml;, arh&acirc;, arh&ouml;, &rsquo;&ocirc;r&ocirc;&ecirc;, neku, s&icirc;sh&euml;&ecirc;.&nbsp;<br />
Au sein de cet ensemble la langue aji&euml; occupe une place pr&eacute;pond&eacute;rante que ce soit au plan d&eacute;mographique, culturel ou religieux. Parl&eacute;e comme langue premi&egrave;re par plus de cinq mille personnes, la langue aji&euml; est certainement connue de l&rsquo;ensemble des locuteurs de l&rsquo;aire Aji&euml;-Aro. .</p>

<p><em>Remarques linguistiques</em></p>

<p>Les langues de l&rsquo;aire aji&euml;-aro sont des langues &agrave; syllabes ouvertes, d&eacute;pourvues de consonnes finales de mot. Comme toutes les langues du sud de la Grande Terre, il s&rsquo;agit de langues &agrave; syst&egrave;me vocalique riche, cause des nombreuses difficult&eacute;s rencontr&eacute;es dans la pratique de ceux qui veulent &eacute;crire ces langues. En revanche leur syst&egrave;me consonantique est moins complexe que celui des langues du nord. Il oppose typiquement des consonnes nasales, semi-nasales et occlusives orales (m, mb, p), des consonnes spirantes (v, y etc.) et des consonnes labiov&eacute;laires (pw, mbw, kw etc).</p>

<p>Dans la continuit&eacute; des langues du nord, il s&rsquo;agit de langues &agrave; ordre VOS&nbsp;: le verbe ou le pr&eacute;dicat arrive en t&ecirc;te de l&rsquo;&eacute;nonc&eacute;, suivi de l&rsquo;objet puis du sujet. Enfin toutes ces langues d&eacute;veloppent un riche syst&egrave;me de compos&eacute;s verbaux, form&eacute;s d&rsquo;un pr&eacute;fixe lexical sp&eacute;cificateur monosyllabique auquel s&rsquo;adjoint un deuxi&egrave;me &eacute;l&eacute;ment polysyllabique.</p>

<p><strong>Aire coutumi&egrave;re Xaracuu</strong></p>

<p>L&rsquo;aire culturelle xaracuu [x&acirc;r&acirc;c&ugrave;&ugrave;] est &agrave; cheval sur la Province sud (communes de La Foa, Sarram&eacute;a, Boulouparis et Thio) et la Province nord (communes de Canala et de Kouaoua). Elle est divis&eacute;e en neuf districts coutumiers (Canala, Kouaoua, Ouatom, Couli, Pa&iuml;ta, Coind&eacute;, Couli, Thio, Borendy). Cette aire culturelle n&rsquo;est pas homog&egrave;ne linguistiquement. Quoique langue de compr&eacute;hension et de communication (fran&ccedil;ais mis &agrave; part) pour l&rsquo;ensemble de la r&eacute;gion, le n&acirc;&acirc; x&acirc;r&acirc;c&ugrave;&ugrave; n&rsquo;est pas la langue maternelle de tous ses habitants. Environ 500 personnes parlent la langue de M&eacute;a, le xaa mea (appel&eacute; aussi n&acirc;&acirc; x&acirc;y&acirc;&acirc; par les locuteurs x&acirc;r&acirc;c&ugrave;&ugrave;), principalement dans les tribus de la cha&icirc;ne au-dessus de Kouaoua, &agrave; Kon&euml;i, W&eacute;rupim&eacute; et W&acirc;&acirc;be (M&eacute;chin), &agrave; Facha, et dans quelques familles &agrave; M&eacute;a M&eacute;bara. Dans l&rsquo;aire x&acirc;r&acirc;c&ugrave;&ugrave;, environ 300 personnes parlent aji&euml; (houailou) de M&eacute;a M&eacute;bara &agrave; Kouaoua et &agrave; Ceynon&nbsp;; le t&icirc;r&icirc; (environ 400 locuteurs) est parl&eacute; dans la r&eacute;gion de Couli/Sarram&eacute;a, principalement dans les tribus de Petit Couli et Grand Couli et, m&eacute;lang&eacute;s &agrave; d&rsquo;autres langues, &agrave; La Foa, Pocquereux, Katrikoin et Sarram&eacute;a&nbsp;; on parle n&acirc;&acirc; x&acirc;r&acirc;gur&egrave; (environ 600 locuteurs) &agrave; Thio-Mission (Saint Philippo II), en partie &agrave; Saint-Michel, Saint-Paul et Saint-Pierre, et dans tous les villages du littoral entre Thio et la rivi&egrave;re N&rsquo;Goye&nbsp;; &agrave; W&icirc;&icirc;n&acirc;r&icirc; (Ouinan&eacute;) les adultes sont bilingues n&acirc;&acirc; x&acirc;r&acirc;gur&egrave;/drubea, les jeunes parlant surtout le fran&ccedil;ais.<br />
Partout ailleurs, on parle le n&acirc;&acirc; x&acirc;r&acirc;c&ugrave;&ugrave;, ce qui repr&eacute;sente plus de 6 000 locuteurs, les trois-quarts vivant sur la commune de Canala, le restant &agrave; Thio.<br />
Le n&acirc;&acirc; x&acirc;r&acirc;c&ugrave;&ugrave; est ainsi parl&eacute; sur un vaste territoire, tr&egrave;s accident&eacute; puisqu&rsquo;il traverse la cha&icirc;ne centrale de Canala &agrave; La Foa, s&rsquo;&eacute;tend de Kouaoua &agrave; Thio le long d&rsquo;un littoral coup&eacute; de fortes collines, et remonte dans les hautes vall&eacute;es transversales. Cette dispersion g&eacute;ographique, avec des enclaves encore relativement isol&eacute;es surtout en p&eacute;riode de pluies, explique l&rsquo;existence de variantes phon&eacute;tiques et lexicales d&rsquo;une vall&eacute;e &agrave; l&rsquo;autre, variantes qui permettent de localiser l&rsquo;origine pr&eacute;cise des locuteurs.</p>

<p><em>Remarques linguistiques</em></p>

<p>Les syst&egrave;mes phonologiques de ces langues sont riches, comportant selon les langues de 26 &agrave; 30 consonnes et de 28 &agrave; 34 voyelles, orales, nasales, br&egrave;ves et longues. La structure syllabique est toujours de type (C)V(C)V&nbsp;: les successions de consonnes et les consonnes finales sont interdites.</p>

<p>Les langues de l&rsquo;aire x&acirc;r&acirc;c&ugrave;&ugrave; ont en commun de pr&eacute;senter peu de variantes morphologiques, des proc&eacute;d&eacute;s de composition, de s&eacute;rialisation verbale et de d&eacute;rivation nombreux et complexes, un ordre des mots VSO, dans lequel S est pr&eacute;c&eacute;d&eacute; d&rsquo;une pr&eacute;position (nr&acirc; en t&icirc;r&icirc;, ng&ecirc; en x&acirc;r&acirc;c&ugrave;&ugrave; et en x&acirc;r&acirc;gur&egrave;) ou SVO, avec, en t&icirc;r&icirc;, reprise pronominale obligatoire du sujet.</p>

<p>Les noms se subdivisent en plusieurs sous-cat&eacute;gories selon la fa&ccedil;on dont ils se poss&egrave;dent&nbsp;: les noms &quot;d&eacute;pendants&quot; sont obligatoirement accompagn&eacute;s de leur possesseur, qui leur est imm&eacute;diatement suffix&eacute;. Les noms ind&eacute;pendants, sans possesseur obligatoirement exprim&eacute;, se poss&egrave;dent soit comme les noms d&eacute;pendants, soit &agrave; l&rsquo;aide de relateurs, qui diff&egrave;rent selon la nature de la relation. Enfin, la possession des nourritures, des plants et des boissons s&rsquo;effectue &agrave; l&rsquo;aide de classificateurs. Ces langues poss&egrave;dent &eacute;galement une petite cat&eacute;gorie de noms locatifs. Les verbes se r&eacute;partissent eux aussi en plusieurs cat&eacute;gories&nbsp;: verbes impersonnels, sans sujet obligatoire, ou n&rsquo;admettant qu&rsquo;un pronom de troisi&egrave;me personne&nbsp;; verbes intransitifs, verbes labiles ou non orient&eacute;s, verbes transitifs et verbes ditransitifs. L&rsquo;objet nominal peut &ecirc;tre d&eacute;fini, accompagn&eacute; d&rsquo;article, ou bien ind&eacute;fini, et il est alors incorpor&eacute; au verbe. Le syst&egrave;me de num&eacute;ration est &agrave; la fois quinaire et vig&eacute;simal. En x&acirc;r&acirc;c&ugrave;&ugrave; et en x&acirc;r&acirc;gur&egrave;, il existe en outre des classificateurs num&eacute;raux sp&eacute;cifiques &agrave; ce que l&rsquo;on compte (ignames, poissons, objets longs, plants). Ces classificateurs sont tomb&eacute;s en d&eacute;su&eacute;tude en t&icirc;r&icirc;. Le syst&egrave;me pronominal est riche, avec trois degr&eacute;s de nombre (singulier, duel, pluriel) et une distinction inclusif/exclusif pour les pronoms de premi&egrave;re personne.</p>

<p><strong>Aire coutumi&egrave;re Djubea-Kapone</strong></p>

<p>L&rsquo;aire linguistique Djubea-Kapone occupe l&rsquo;extr&ecirc;me-sud de la Grande Terre depuis la r&eacute;gion de Paita (c&ocirc;te ouest) et Unia (c&ocirc;te est) jusqu&rsquo;&agrave; l&rsquo;&icirc;le des Pins.</p>

<p>Il s&rsquo;agit d&rsquo;une aire homog&egrave;ne, form&eacute;e de deux langues proches mais nettement distinctes des langues parl&eacute;es dans les aires aji&euml;-arh&ouml; ou x&acirc;r&acirc;c&ugrave;&ugrave;. En particulier, ces deux langues de l&rsquo;extr&ecirc;me sud sont des langues tonales.</p>

<p>L&rsquo;aire linguistique de l&rsquo;extr&ecirc;me sud &eacute;tait appel&eacute;e &agrave; date ancienne &laquo;&nbsp;n&acirc;&acirc; num&eacute;a&nbsp;&raquo;. Cette aire s&rsquo;est subdivis&eacute;e par la suite en deux langues qui, chacune &agrave; leur mani&egrave;re, ont conserv&eacute; le nom ancien&nbsp;: drub&eacute;a (n&acirc;&acirc; drub&eacute;a) pour la partie nord de cette r&eacute;gion &eacute;tant l&rsquo;&eacute;quivalent du mot &laquo;&nbsp;num&egrave;&egrave;&nbsp;&raquo; utilis&eacute; au sud. Le num&egrave;&egrave; est &agrave; son tour subdivis&eacute; en deux dialectes&nbsp;: le num&egrave;&egrave; proprement dit, parl&eacute; sur la Grande Terre, et le kw&ecirc;nyii qui est parl&eacute; &agrave; l&rsquo;&icirc;le des Pins. Nous consacrons une fiche &agrave; chacun de ces deux dialectes passablement distincts. Ils ont &eacute;t&eacute; regroup&eacute;s ensemble sous le vocable &laquo;&nbsp;kapone&nbsp;&raquo; par M.&nbsp;Leenhardt (1946). C&rsquo;est ce terme &laquo;&nbsp;kapone&nbsp;&raquo;, g&eacute;n&eacute;ralement inconnu ou tomb&eacute; en d&eacute;su&eacute;tude, qui a &eacute;t&eacute; repris pour d&eacute;signer l&rsquo;aire coutumi&egrave;re de l&rsquo;extr&ecirc;me-sud, dite maintenant &laquo;&nbsp;Djubea-Kapone&nbsp;&raquo;.</p>

<p>Les deux langues de l&rsquo;extr&ecirc;me-sud ont fait l&rsquo;objet d&rsquo;une &eacute;tude phonologique d&eacute;taill&eacute;e, synchronique et diachronique (Rivierre, 1973). Il s&rsquo;agit en effet de langues complexes, chacune d&rsquo;elles s&rsquo;av&eacute;rant conservatrice dans l&rsquo;un ou l&rsquo;autre domaine de la phonologie locale&nbsp;: le drub&eacute;a pour les voyelles, le num&egrave;&egrave; pour les consonnes, enfin le n&acirc;&acirc; kw&ecirc;nyii (&icirc;le des Pins), dialecte du num&egrave;&egrave;, reste le plus proche du syst&egrave;me tonal ancien, lequel s&rsquo;est invers&eacute; en drub&eacute;a et en num&egrave;&egrave;.</p>

<h3>Langues kanak des Loyaut&eacute;.</h3>

<p>On y trouve trois langues m&eacute;lan&eacute;siennes et une langue d&rsquo;origine polyn&eacute;sienne (le fagauvea) implant&eacute;e &agrave; Ouv&eacute;a depuis quelques si&egrave;cles et assez profond&eacute;ment transform&eacute;e au contact de sa voisine m&eacute;lan&eacute;sienne, le iaai.</p>

<p><strong>Aire coutumi&egrave;re Nengone</strong>&nbsp;: Nengone</p>

<p><strong>Aire coutumi&egrave;re Drehu</strong>&nbsp;: Drehu</p>

<p><strong>Aire coutumi&egrave;re Iaai </strong>&nbsp;: Iaai, Fagauvea</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['left'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => 'Les langues de Nouvelle Calédonie',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['right'][0] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['les_langues_kanaks'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'outre_mer';
  $page->task = 'page';
  $page->admin_title = 'Outre-mer';
  $page->admin_description = 'Les langues de France : un patrimoine méconnu, une réalité vivante';
  $page->path = 'langues-outre-mer';
  $page->access = array();
  $page->menu = array(
    'type' => 'normal',
    'title' => 'Outre-mer',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_outre_mer__panel_context_bd242287-2a13-464b-930a-1e6c2b031eec';
  $handler->task = 'page';
  $handler->subtask = 'outre_mer';
  $handler->handler = 'panel_context';
  $handler->weight = 0;
  $handler->conf = array(
    'title' => 'Outre-mer',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => '',
    'css_id' => 'langues_outre_mer',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Zone Caraibe',
        'keyword' => 'taxonomy_term_zone_caraibe',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '7',
        'id' => 1,
      ),
      1 => array(
        'identifier' => 'Mayotte',
        'keyword' => 'taxonomy_term_mayotte',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '11',
        'id' => 2,
      ),
      2 => array(
        'identifier' => 'Nouvelle Caledonie',
        'keyword' => 'taxonomy_term_nouvelle_caledonie',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '10',
        'id' => 3,
      ),
      3 => array(
        'identifier' => 'Polynesie francaise',
        'keyword' => 'taxonomy_term_polynesie_francaise',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '8',
        'id' => 4,
      ),
      4 => array(
        'identifier' => 'Wallis et Futuna',
        'keyword' => 'taxonomy_term_wallis_futuna',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '9',
        'id' => 5,
      ),
      5 => array(
        'identifier' => 'Réunion',
        'keyword' => 'taxonomy_term_reunion',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '13',
        'id' => 6,
      ),
    ),
    'relationships' => array(),
    'name' => '',
  );
  $display = new panels_display();
  $display->layout = 'onecol';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => NULL,
      'middle' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '12',
          'lg' => '12',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '8',
          'sm' => '8',
          'md' => '8',
          'lg' => '8',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '4',
          'sm' => '4',
          'md' => '4',
          'lg' => '4',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
    'middle' => array(
      'style' => 'bootstrap_region',
    ),
  );
  $display->cache = array();
  $display->title = 'Outre-mer';
  $display->uuid = '82cfb20d-5785-467a-b8b8-e18d5a1429d5';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_outre_mer__panel_context_bd242287-2a13-464b-930a-1e6c2b031eec';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte Outre-mer',
    'title' => '',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt. Cras dapibus. Vivamus elementum semper nisi.</p>

<p>Aenean vulputate eleifend tellus. Aenean leo ligula, porttitor eu, consequat vitae, eleifend ac, enim. Aliquam lorem ante, dapibus in, viverra quis, feugiat a, tellus. Phasellus viverra nulla ut metus varius laoreet. Quisque rutrum. Aenean imperdiet. Etiam ultricies nisi vel augue. Curabitur ullamcorper ultricies nisi. Nam eget dui. Etiam rhoncus. Maecenas tempus, tellus eget condimentum rhoncus, sem quam semper libero, sit amet adipiscing sem neque sed ipsum. Nam quam nunc, blandit vel, luctus pulvinar, hendrerit id, lorem.</p>

<p>Maecenas nec odio et ante tincidunt tempus. Donec vitae sapien ut libero venenatis faucibus. Nullam quis ante. Etiam sit amet orci eget eros faucibus tincidunt. Duis leo. Sed fringilla mauris sit amet nibh. Donec sodales sagittis magna. Sed consequat, leo eget bibendum sodales, augue velit cursus nunc, quis gravida magna mi a libero. Fusce vulputate eleifend sapien. Vestibulum purus quam, scelerisque ut, mollis sed, nonummy id, metus. Nullam accumsan lorem in dui. Cras ultricies mi eu turpis hendrerit fringilla. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; In ac dui quis mi consectetuer lacinia. Nam pretium turpis et arcu. Duis arcu tortor, suscipit eget, imperdiet nec, imperdiet iaculis, ipsum. Sed aliquam ultrices mauris. Integer ante arcu, accumsan a, consectetuer eget, posuere ut, mauris. Praesent adipiscing. Phasellus ullamcorper ipsum rutrum nunc. Nunc nonummy metus. Vestibulum volutpat pretium libero. Cras id dui. Aenean ut</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $display->content['new-7c7d662b-8d85-4802-bd37-f7c65fe91a44'] = $pane;
  $display->panels['middle'][0] = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $pane = new stdClass();
  $pane->pid = 'new-620824dd-3a97-4924-91e7-afbcdb9c7945';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Menu interne Page Outre-mer',
    'title' => '',
    'body' => '<ul>
	<li><a href="#langues-zone-caraibe-texte">Zone Caraibe</a></li>
	<li><a href="#langues-reunion-texte">R&eacute;union</a></li>
	<li><a href="#langues-mayotte-texte">Mayotte</a></li>
	<li><a href="#langues-nouvelle-caledonie-texte">Nouvelle Cal&eacute;donie</a></li>
	<li><a href="#langues-polynesie-francaise-texte">Polyn&eacute;sie fran&ccedil;aise</a></li>
	<li><a href="#langues-wallis-futuna-texte">Wallis et Futuna</a></li>
</ul>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'outre-mer-internal-menu',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 1;
  $pane->locks = array();
  $pane->uuid = '620824dd-3a97-4924-91e7-afbcdb9c7945';
  $display->content['new-620824dd-3a97-4924-91e7-afbcdb9c7945'] = $pane;
  $display->panels['middle'][1] = 'new-620824dd-3a97-4924-91e7-afbcdb9c7945';
  $pane = new stdClass();
  $pane->pid = 'new-db20769f-2e60-412f-80fa-e0599ad35c54';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte Zone caraïbe',
    'title' => 'Zone caraïbe',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-zone-caraibe-texte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 2;
  $pane->locks = array();
  $pane->uuid = 'db20769f-2e60-412f-80fa-e0599ad35c54';
  $display->content['new-db20769f-2e60-412f-80fa-e0599ad35c54'] = $pane;
  $display->panels['middle'][2] = 'new-db20769f-2e60-412f-80fa-e0599ad35c54';
  $pane = new stdClass();
  $pane->pid = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h3',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-zone-caraibe',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 3;
  $pane->locks = array();
  $pane->uuid = 'd260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $display->content['new-d260b1a6-cb5c-43c5-b60c-46190367bc8f'] = $pane;
  $display->panels['middle'][3] = 'new-d260b1a6-cb5c-43c5-b60c-46190367bc8f';
  $pane = new stdClass();
  $pane->pid = 'new-1d418bf9-1ec3-45c7-9769-89f8ad29843b';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte réunion',
    'title' => 'Réunion',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-reunion-texte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 4;
  $pane->locks = array();
  $pane->uuid = '1d418bf9-1ec3-45c7-9769-89f8ad29843b';
  $display->content['new-1d418bf9-1ec3-45c7-9769-89f8ad29843b'] = $pane;
  $display->panels['middle'][4] = 'new-1d418bf9-1ec3-45c7-9769-89f8ad29843b';
  $pane = new stdClass();
  $pane->pid = 'new-4f7a8f77-5593-409b-b8a7-bbd0cab527da';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'context' => array(
      0 => 'context_entity:taxonomy_term_6.tid',
    ),
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h3',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-reunion',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 5;
  $pane->locks = array();
  $pane->uuid = '4f7a8f77-5593-409b-b8a7-bbd0cab527da';
  $display->content['new-4f7a8f77-5593-409b-b8a7-bbd0cab527da'] = $pane;
  $display->panels['middle'][5] = 'new-4f7a8f77-5593-409b-b8a7-bbd0cab527da';
  $pane = new stdClass();
  $pane->pid = 'new-9fd88908-a90b-49fe-998f-cad1d70d54c6';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte Mayotte',
    'title' => 'Mayotte',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate</p>

<p><a href="/langues-de-mayotte">En savoir plus</a></p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-mayotte-texte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 6;
  $pane->locks = array();
  $pane->uuid = '9fd88908-a90b-49fe-998f-cad1d70d54c6';
  $display->content['new-9fd88908-a90b-49fe-998f-cad1d70d54c6'] = $pane;
  $display->panels['middle'][6] = 'new-9fd88908-a90b-49fe-998f-cad1d70d54c6';
  $pane = new stdClass();
  $pane->pid = 'new-e5d44c2f-8596-42c2-840c-f188224b82b7';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'context' => array(
      0 => 'context_entity:taxonomy_term_2.tid',
    ),
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h3',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-mayotte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 7;
  $pane->locks = array();
  $pane->uuid = 'e5d44c2f-8596-42c2-840c-f188224b82b7';
  $display->content['new-e5d44c2f-8596-42c2-840c-f188224b82b7'] = $pane;
  $display->panels['middle'][7] = 'new-e5d44c2f-8596-42c2-840c-f188224b82b7';
  $pane = new stdClass();
  $pane->pid = 'new-83c740cf-11fd-43d2-9d1d-865914527bcf';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte nouvelle Calédonie',
    'title' => 'Nouvelle Calédonie',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate</p>

<p><a href="/langues-kanaks">En savoir plus</a></p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-nouvelle-caledonie-texte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 8;
  $pane->locks = array();
  $pane->uuid = '83c740cf-11fd-43d2-9d1d-865914527bcf';
  $display->content['new-83c740cf-11fd-43d2-9d1d-865914527bcf'] = $pane;
  $display->panels['middle'][8] = 'new-83c740cf-11fd-43d2-9d1d-865914527bcf';
  $pane = new stdClass();
  $pane->pid = 'new-bfe857cc-42c6-42fe-b253-72651bfaaa6a';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'context' => array(
      0 => 'context_entity:taxonomy_term_3.tid',
    ),
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h3',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-nouvelle-caledonie',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 9;
  $pane->locks = array();
  $pane->uuid = 'bfe857cc-42c6-42fe-b253-72651bfaaa6a';
  $display->content['new-bfe857cc-42c6-42fe-b253-72651bfaaa6a'] = $pane;
  $display->panels['middle'][9] = 'new-bfe857cc-42c6-42fe-b253-72651bfaaa6a';
  $pane = new stdClass();
  $pane->pid = 'new-f65cea20-7338-48d5-9d10-4aa424721147';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte Polynésie française',
    'title' => 'Polynésie française',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate</p>

<p><a href="/langues-de-guyane">En savoir plus</a></p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-polynesie-francaise-texte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 10;
  $pane->locks = array();
  $pane->uuid = 'f65cea20-7338-48d5-9d10-4aa424721147';
  $display->content['new-f65cea20-7338-48d5-9d10-4aa424721147'] = $pane;
  $display->panels['middle'][10] = 'new-f65cea20-7338-48d5-9d10-4aa424721147';
  $pane = new stdClass();
  $pane->pid = 'new-aab59b4c-7690-4894-b0ae-56cda2564f19';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'context' => array(
      0 => 'context_entity:taxonomy_term_4.tid',
    ),
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h3',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-polynesie-francaise',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 11;
  $pane->locks = array();
  $pane->uuid = 'aab59b4c-7690-4894-b0ae-56cda2564f19';
  $display->content['new-aab59b4c-7690-4894-b0ae-56cda2564f19'] = $pane;
  $display->panels['middle'][11] = 'new-aab59b4c-7690-4894-b0ae-56cda2564f19';
  $pane = new stdClass();
  $pane->pid = 'new-723ffc51-9a29-40b4-9b7d-c20cc8d5c765';
  $pane->panel = 'middle';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'Texte Wallis et Futuna',
    'title' => 'Wallis et Futuna',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-wallis-futuna-texte',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 12;
  $pane->locks = array();
  $pane->uuid = '723ffc51-9a29-40b4-9b7d-c20cc8d5c765';
  $display->content['new-723ffc51-9a29-40b4-9b7d-c20cc8d5c765'] = $pane;
  $display->panels['middle'][12] = 'new-723ffc51-9a29-40b4-9b7d-c20cc8d5c765';
  $pane = new stdClass();
  $pane->pid = 'new-c147f88a-6d64-4d3d-97b1-42e67ef5b892';
  $pane->panel = 'middle';
  $pane->type = 'views';
  $pane->subtype = 'langues_isotope';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block_1',
    'context' => array(
      0 => 'context_entity:taxonomy_term_5.tid',
    ),
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h3',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array(
    'css_id' => 'langues-wallis-futuna',
    'css_class' => '',
  );
  $pane->extras = array();
  $pane->position = 13;
  $pane->locks = array();
  $pane->uuid = 'c147f88a-6d64-4d3d-97b1-42e67ef5b892';
  $display->content['new-c147f88a-6d64-4d3d-97b1-42e67ef5b892'] = $pane;
  $display->panels['middle'][13] = 'new-c147f88a-6d64-4d3d-97b1-42e67ef5b892';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-7c7d662b-8d85-4802-bd37-f7c65fe91a44';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['outre_mer'] = $page;

  $page = new stdClass();
  $page->disabled = FALSE; /* Edit this to true to make a default page disabled initially */
  $page->api_version = 1;
  $page->name = 'projets';
  $page->task = 'page';
  $page->admin_title = 'Projets';
  $page->admin_description = 'descript langues';
  $page->path = 'projets';
  $page->access = array();
  $page->menu = array(
    'type' => 'normal',
    'title' => 'Projets',
    'name' => 'main-menu',
    'weight' => '0',
    'parent' => array(
      'type' => 'none',
      'title' => '',
      'name' => 'navigation',
      'weight' => '0',
    ),
  );
  $page->arguments = array();
  $page->conf = array(
    'admin_paths' => FALSE,
  );
  $page->default_handlers = array();
  $handler = new stdClass();
  $handler->disabled = FALSE; /* Edit this to true to make a default handler disabled initially */
  $handler->api_version = 1;
  $handler->name = 'page_projets__projets';
  $handler->task = 'page';
  $handler->subtask = 'projets';
  $handler->handler = 'panel_context';
  $handler->weight = 1;
  $handler->conf = array(
    'title' => 'Projets',
    'no_blocks' => 0,
    'pipeline' => 'standard',
    'body_classes_to_remove' => '',
    'body_classes_to_add' => 'projets-page',
    'css_id' => '',
    'css' => '',
    'contexts' => array(
      0 => array(
        'identifier' => 'Taxonomy term',
        'keyword' => 'taxonomy_term',
        'name' => 'entity:taxonomy_term',
        'entity_id' => '3',
        'id' => 1,
      ),
    ),
    'relationships' => array(
      0 => array(
        'identifier' => 'Taxonomy vocabulary from Taxonomy term (on taxonomy_term_data.vocabulary)',
        'keyword' => 'taxonomy_vocabulary',
        'name' => 'entity_from_schema:vid-taxonomy_term-taxonomy_vocabulary',
        'context' => 'context_entity:taxonomy_term_1',
        'id' => 1,
      ),
    ),
    'name' => 'projets',
  );
  $display = new panels_display();
  $display->layout = 'bootstrap_twocol_stacked';
  $display->layout_settings = array();
  $display->panel_settings = array(
    'style_settings' => array(
      'default' => array(
        'css_id' => '',
        'css_class' => 'row',
        'column' => array(
          'xs' => '1',
          'sm' => '1',
          'md' => '1',
          'lg' => '1',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'top' => NULL,
      'left' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '6',
          'lg' => '6',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'right' => array(
        'css_id' => '',
        'css_class' => '',
        'column' => array(
          'xs' => '12',
          'sm' => '12',
          'md' => '6',
          'lg' => '6',
        ),
        'offset' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'push' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
        'pull' => array(
          'xs' => '0',
          'sm' => '0',
          'md' => '0',
          'lg' => '0',
        ),
      ),
      'bottom' => NULL,
    ),
    'left' => array(
      'style' => 'bootstrap_region',
    ),
    'right' => array(
      'style' => 'bootstrap_region',
    ),
    'style' => 'bootstrap_region',
  );
  $display->cache = array();
  $display->title = 'Titre Projets';
  $display->uuid = 'dc9c91a8-8045-45e5-aaca-89b0ff37b338';
  $display->storage_type = 'page_manager';
  $display->storage_id = 'page_projets__projets';
  $display->content = array();
  $display->panels = array();
  $pane = new stdClass();
  $pane->pid = 'new-e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $pane->panel = 'left';
  $pane->type = 'custom';
  $pane->subtype = 'custom';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'admin_title' => 'texte projets',
    'title' => '',
    'body' => '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.&nbsp;</p>

<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.&nbsp;Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in. Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Morbi a tempor massa. Praesent condimentum ullamcorper diam, non pulvinar magna sollicitudin in.</p>

<p>Donec aliquam nulla at libero ornare, laoreet volutpat lorem luctus. Praesent sed laoreet felis. Donec dapibus vehicula augue at blandit. Sed ac malesuada urna. Quisque id elit sit amet turpis facilisis rhoncus. Vestibulum pharetra ligula vitae volutpat fringilla.</p>
',
    'format' => 'basic_html',
    'substitute' => 1,
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
    'style' => 'default',
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = 'e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $display->content['new-e43762a6-06d6-45cb-b947-cf5c9611a1e6'] = $pane;
  $display->panels['left'][0] = 'new-e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $pane = new stdClass();
  $pane->pid = 'new-36cbf500-7c44-4681-a9a4-50934c728dba';
  $pane->panel = 'right';
  $pane->type = 'views';
  $pane->subtype = 'blocs_image_corpus_langues_etc';
  $pane->shown = TRUE;
  $pane->access = array();
  $pane->configuration = array(
    'override_pager_settings' => 0,
    'use_pager' => 0,
    'nodes_per_page' => '4',
    'pager_id' => '0',
    'offset' => '0',
    'more_link' => 0,
    'feed_icons' => 0,
    'panel_args' => 0,
    'link_to_view' => 0,
    'args' => '',
    'url' => '',
    'display' => 'block',
    'context' => array(
      0 => 'context_entity:taxonomy_term_1.tid',
    ),
    'override_title' => 1,
    'override_title_text' => '',
    'override_title_heading' => 'h2',
  );
  $pane->cache = array();
  $pane->style = array(
    'settings' => NULL,
  );
  $pane->css = array();
  $pane->extras = array();
  $pane->position = 0;
  $pane->locks = array();
  $pane->uuid = '36cbf500-7c44-4681-a9a4-50934c728dba';
  $display->content['new-36cbf500-7c44-4681-a9a4-50934c728dba'] = $pane;
  $display->panels['right'][0] = 'new-36cbf500-7c44-4681-a9a4-50934c728dba';
  $display->hide_title = PANELS_TITLE_FIXED;
  $display->title_pane = 'new-e43762a6-06d6-45cb-b947-cf5c9611a1e6';
  $handler->conf['display'] = $display;
  $page->default_handlers[$handler->name] = $handler;
  $pages['projets'] = $page;

  return $pages;

}
