<?php

use Mockery as m;

use CorpusParole\Services\GeonamesResolverException;

/**
 *
 */
class GeonamesControllerTest extends TestCase {

    private $geonamesResolver;

    public function setUp() {

        parent::setup();

        // create a mock of the post repository interface and inject it into the
        // IoC container
        $this->geonamesResolver = m::mock('CorpusParole\Services\GeonamesResolverInterface');
        $this->app->instance('CorpusParole\Services\GeonamesResolverInterface', $this->geonamesResolver);
    }

    public function tearDown() {
        m::close();
        parent::tearDown();
    }

    public function testShow() {
        $this->geonamesResolver
            ->shouldReceive('getLabels')
            ->with(['2968801', '2988507', '6255148'])
            ->once()
            ->andReturn(['2968801' => 'Villedieu-les-Poêles', '2988507' => 'Paris', '6255148' => 'Europe']);

        $response = $this->get('/api/v1/geonames/2968801,2988507,6255148')->
            seeJsonEquals(['geonamesids' => ['2968801' => 'Villedieu-les-Poêles', '2988507' => 'Paris', '6255148' => 'Europe']]);
    }

    public function testShowOne() {
        $this->geonamesResolver
            ->shouldReceive('getLabels')
            ->with(['2968801'])
            ->once()
            ->andReturn([
                '2968801' => 'Villedieu-les-Poêles'
            ]);
        $response = $this->get('/api/v1/geonames/2968801')->
            seeJsonEquals(['geonamesids' => [
                '2968801' => 'Villedieu-les-Poêles'
            ]]);
    }

    public function testShowUnknown() {
        $this->geonamesResolver
            ->shouldReceive('getLabels')
            ->with(['12345'])
            ->once()
            ->andReturn([
                '12345' => null
            ]);
        $response = $this->get('/api/v1/geonames/12345')->
            seeJsonEquals(['geonamesids' => [
                '12345' => null
            ]]);
    }

    public function testShowMalformed() {
        $this->geonamesResolver
            ->shouldReceive('getLabels')
            ->with(['abcdef','ghij'])
            ->once()
            ->andThrow('CorpusParole\Services\GeonamesResolverException', "GeonamesId not in correct format", 400);
        $response = $this->get('/api/v1/geonames/abcdef,ghij');

        $this->assertResponseStatus(400);
    }

}
