<?php

use Illuminate\Http\Request;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
|
*/
Route::group(['prefix' => 'v1'] , function() {
    Route::pattern('documents', ".*");

    Route::get('documents/{id}/transcript', 'Api\DocumentController@transcript');
    Route::resource('documents', 'Api\DocumentController',
                    ['only' => ['index', 'show', 'update']]);
    Route::resource('viaf', 'Api\ViafController',
                    ['only' => ['show']]);
    Route::resource('lexvo', 'Api\LexvoController',
                    ['only' => ['show']]);
    Route::resource('bnf', 'Api\BnfController',
                    ['only' => ['index','show']]);
    Route::resource('geonames', 'Api\GeonamesController',
                    ['only' => ['index','show']]);
    Route::resource('languages', 'Api\LanguageController',
                    ['only' => ['index']]);
    Route::resource('themes', 'Api\ThemeController',
                    ['only' => ['index']]);
    Route::resource('discourses', 'Api\DiscourseController',
                    ['only' => ['index']]);
});