/*jshint node:true*/
var proxyPath = '/proxy/bnf-sparql';

module.exports = function(app) {
  // For options, see:
  // https://github.com/nodejitsu/node-http-proxy
  var proxy = require('http-proxy').createProxyServer({});

  proxy.on('error', function(err, req) {
    console.error(err, req.url);
  });

  app.use(proxyPath, function(req, res, next){
    // include root path in proxied request
    //req.url = proxyPath + '/' + req.url;
    req.url = req.url.slice(1);
    proxy.web(req, res, { target: 'http://data.bnf.fr/sparql' });
  });
};
