/*jshint node:true*/
module.exports = function(app) {
    var express = require('express');
    var _ = require('lodash');

    var v1GeonamesRouter = express.Router();

    var geonamesMappings = require('../fixtures/geonames');

    v1GeonamesRouter.get('/:id', function(req, res) {
        var idList = req.params.id.split(',');
        res.send({
            'geonamesids': _.reduce(idList, function(r, id) {
                r[id] = (id in geonamesMappings)?geonamesMappings[id]:null;
                return r;
            }, {}),
        });
    });

    app.use('/api/v1/geonames', v1GeonamesRouter);
};
