import Ember from 'ember';

export default Ember.Component.extend({

    filter: Ember.inject.service(),

    dateObserver: Ember.observer('filter.date', function() {
        var self = this;
        this.$('li').removeClass('highlighted');
        this.get('filter').get('date').forEach(function(date) {
            self.$('li#' + date).addClass('highlighted');
        });
    }),

    elementId: "chrono-table",

    didInsertElement: function(){
        var self = this;

        if (this.get('filter').get('date') !== null){
            this.highlightQuery(this.get('filter').get('date'));
        }

        var isMouseDown = false,
            isHighlighted,
            didHighlight,
            previousElement;

        Ember.$("#chrono-table li").mousedown(function (event) {
            // Prevent right click selection.
            if(event.button === 0) {
                
                isMouseDown = true;
                var element = parseInt(Ember.$(this).attr('id'));
                var elements = [element];
                if(event.shiftKey) {
                    while(previousElement !== element) {
                        elements.push(previousElement);
                        if(previousElement < element) {
                            previousElement = previousElement + 1;
                        } else if(previousElement > element) {
                            previousElement = previousElement - 1;
                        } else {
                            break;
                        }
                    }    
                }
                var dates = self.get('filter').get('date').toArray();
                var index = dates.indexOf(element);
                if((!event.shiftKey && index === -1) || (event.shiftKey && didHighlight)) {
                    dates = dates.concat(elements);
                    isHighlighted = true;
                } else {
                    elements.forEach(function(el) {
                        var id = dates.indexOf(el);
                        if((!event.shiftKey && index !== -1) || (event.shiftKey && id !== -1)) {
                            dates.splice(id, 1);    
                        }
                    });
                    isHighlighted = false;
                }
                // Ascending sorting.
                dates.sort(function(a, b) { return a - b; });
                self.get('filter').set('date', dates);
                didHighlight = isHighlighted;
                previousElement = element;
                // Prevent text selection.
                return false;
            }
        }).mouseover(function () {
            if (isMouseDown) {
                var element = parseInt(Ember.$(this).attr('id'));
                if(Ember.$(this).hasClass("highlighted") !== isHighlighted) {
                    var dates = self.get('filter').get('date').toArray();
                    var index = dates.indexOf(element);
                    if(index === -1) {
                        dates.push(element);
                    } else {
                        dates.splice(index, 1);
                    }
                    self.get('filter').set('date', dates);
                }
                previousElement = element;
            }
        }).bind("selectstart", function () {
            return false;
        });

        Ember.$(document).mouseup(function () {
            isMouseDown = false;
        });
    },

    highlightQuery: function(dates){
        dates.map(function(date){
            Ember.$("#" + date).toggleClass("highlighted", true);
        });
    },

    actions : {

        selectDecade: function(decade) {
            var array = [];
            var next = decade + 10;
            var dates = this.get('filter').get('date');
            while(decade < next) {
                array.push(decade);
                decade ++;
            }
            if(array.find(function(date){ return dates.indexOf(date) === -1; })) {
                array = array.filter(function(value) {
                    return dates.indexOf(value) === -1;
                });
                array = dates.concat(array);
                // Ascending sorting.
                array.sort(function(a, b) { return a - b; });
            } else {
                array = dates.filter(function(value) {
                    return array.indexOf(value) === -1;
                });
            }
            this.get('filter').set('date', array);
        }

    }

});
