<?php

namespace CorpusParole\Http\Controllers\Api;

// use Illuminate\Http\Request;
// use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;

use Illuminate\Http\Request;
use EasyRdf\Resource;
use EasyRdf\Literal;

use CorpusParole\Libraries\Sparql\SparqlClient;
use CorpusParole\Services\LexvoResolverInterface;
use CorpusParole\Services\BnfResolverInterface;


class ThemeController extends Controller
{
    private $sparqlClient = null;

    public function __construct(SparqlClient $sparqlClient, LexvoResolverInterface $lexvoResolver, BnfResolverInterface $bnfResolver) {
        $this->sparqlClient = $sparqlClient;
        $this->lexvoResolver = $lexvoResolver;
        $this->bnfResolver = $bnfResolver;
    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $filter = $request->input('filter', 'bnf');
        $resolve = filter_var($request->input('resolve', true), FILTER_VALIDATE_BOOLEAN);

        $filterClause = "";

        if($filter === 'bnf') {
            $filterClause = "FILTER (isIRI(?o) && regex(str(?o), '^".config('corpusparole.bnf_ark_base_url')."')) .";
        }
        elseif($filter === 'uri') {
            $filterClause = "FILTER isIRI(?o) .";
        }
        elseif($filter === 'all' || $filter === 'none' || $filter === '') {
            $filterClause = "";
        }
        else {
            abort(401,"Value for filter parameter must be in 'bnf', 'uri', 'all' or 'none'");
        }

        $query =  preg_replace('/\s+/', ' ',
         "select (?o as ?theme) (COUNT(?s) as ?count) where {
            ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO> .
            ?s <http://purl.org/dc/elements/1.1/subject> ?o .
            $filterClause
          }
          GROUP BY ?o
          ORDER BY DESC(?count)");

        $docs = $this->sparqlClient->query($query);

        $themes = [];
        $labels = [];

        $bnfUris = [];
        $lexvoUris = [];

        foreach ($docs as $row) {
            $key = "";
            $label = null;
            if($row->theme instanceof Resource) {
                $key = $row->theme->getUri();
                if($resolve && strpos($key, config('corpusparole.bnf_ark_base_url')) === 0) {
                    array_push($bnfUris, $key);
                }
                elseif($resolve && strpos($key, config('corpusparole.lexvo_base_url')) === 0) {
                    array_push($lexvoUris, $key);
                }
                $label = null;
            }
            elseif($row->theme instanceof Literal) {
                $key = $row->theme->getValue();
                $label = $row->theme->getValue();
            }

            $themes[$key] = [
                "label" => $label,
                "count" => $row->count->getValue()
            ];
        }

        if($resolve) {
            if(count($lexvoUris) > 0) {
                $labels = $this->lexvoResolver->getNames($lexvoUris);
            }
            if(count($bnfUris) > 0) {
                $labels = array_merge($labels, $this->bnfResolver->getLabels($bnfUris));
            }
            foreach ($themes as $themeKey => $themeDef) {
                if(array_key_exists($themeKey, $labels)) {
                    $themeDef['label'] = $labels[$themeKey];
                }
                $themes[$themeKey] = $themeDef;
            }
        }

        return response()->json(['themes' => $themes ]);

    }

}
