import Ember from 'ember';
import * as constants from 'corpus-common-addon/utils/constants';
import layout from '../templates/components/doc-subject';

export default Ember.Component.extend({
    layout: layout,
    tagName: "span",
    displayLabel: Ember.computed('label', 'resolvedLabel', function() {
      return this.get('label') || this.get('resolvedLabel');
    }),
    bnfResolver: Ember.inject.service(),

    _resolveBnfIds: Ember.on('init', Ember.observer('url', 'label', function() {
      if(this.get('label')) {
        if (!(this.get('isDestroyed') || this.get('isDestroying'))) {
          this.set('resolvedLabel', this.get('label'));
        }
        return;
      }
      this.get('bnfResolver').getLabel(this.get('url')).then(function(str) {
        if (!(this.get('isDestroyed') || this.get('isDestroying'))) {
          this.set('resolvedLabel', str);
        }
      }.bind(this));
    })),

    code: Ember.computed('url', function() {
      var rawSubject = this.get('url');
      if(rawSubject) {
        if(rawSubject.startsWith(constants.BNF_BASE_URL)) {
          return rawSubject.substr(constants.BNF_BASE_URL.length);
        }
        else if (rawSubject.startsWith(constants.BNF_ARK_BASE_URL)) {
          return rawSubject.substr(constants.BNF_ARK_BASE_URL.length);
        }
      }
      return rawSubject;
    }),
    isSubjectLink: Ember.computed.match('url', /^http\:\/\//)

});
