import JSONAPISerializer from 'ember-data/serializers/json-api';

export default JSONAPISerializer.extend({

    normalizeResponse: function(store, primaryModelClass, payload, id, requestType) {
        var lang = false;

        var annotations = [];
        payload.annotations.forEach(function(annotation) {
            var annotationObject = {
                'content': annotation.content.data.content,
                'start': annotation.begin,
                'end': annotation.end
            };
            if(annotation.content.data.transl) {
                annotationObject.translation = annotation.content.data.transl['@value'];
                if (!lang) {
                    lang = annotation.content.data.transl['@language'];    
                }
            }
            if(annotation.content.data.words) {
                var words = [];
                annotation.content.data.words.forEach(function(word) {
                    var wordObject = {
                        'content': word.content,
                        'translation': word.transl['@value']
                    };
                    words.push(wordObject);
                })
                annotationObject.words = words;
            }
            annotations.push(annotationObject);
        });

        var response = {
            'data': {
                'id': id,
                'type': 'transcript',
                'attributes': {
                    'title': {},
                    'annotations': annotations
                }
            }
        };

        if(Array.isArray(payload.meta['dc:title'])) {
            var original = payload.meta['dc:title'].find(function(title) { return title['@language'] !== lang; });
            var translation = payload.meta['dc:title'].find(function(title) { return title['@language'] === lang; });
            if(original) {
                response.data.attributes.title.original = original['@value'];
            }
            if(translation) {
                response.data.attributes.title.translation = translation['@value'];
            }            
        } else {
            response.data.attributes.title.original = payload.meta['dc:title']['@value'];
        }


        return response;
    }

});
