import Ember from 'ember';

export function intDisplay(params/*, hash*/) {
  if(!params || params.length === 0) {
    return Ember.String.htmlSafe('');
  }
  const nb = params[0];
  if(nb === Number.NEGATIVE_INFINITY || Number.isNaN(nb) || nb === Number.POSITIVE_INFINITY ) {
    return Ember.String.htmlSafe('');
  }
  return Ember.String.htmlSafe(`${nb}`);
}

export default Ember.Helper.helper(intDisplay);
