import { JSONAPISerializer } from 'ember-cli-mirage';

import _ from 'lodash/lodash';

export default JSONAPISerializer.extend({
    serialize(response, request) {

      let json = JSONAPISerializer.prototype.serialize.apply(this, arguments);

      let qParams = request.queryParams['discourse'];
      if(qParams) {
        json =  { 'data': _.map(json.data.slice(0, json.data.length/Math.pow(2,qParams.length)), (lang) => {
          let resLang = _.clone(lang);
          resLang.attributes.count = Math.max(Math.floor(resLang.attributes.count / 2), 1);
          return resLang;
        })};
      }

      return {'languages' : _(json.data).map((lang) => { return [lang.id, lang.attributes.count];}).object().value()};
    }
});
