import DS from 'ember-data';

export default DS.JSONSerializer.extend({

    normalizeResponse: function(store, primaryModelClass, payload) {
        var data = [];
        var themes = payload['themes'];
        Object.keys(themes).forEach(function(key) {
            data.push({
                'id': key,
                'type': 'theme',
                'attributes': {
                    'label': themes[key].label,
                    'count': themes[key].count
                }
            });
        });
        return {
            'data': data,
            'meta': payload['meta']
        };
    }

});
