<?php
namespace CorpusParole\Libraries\Mergers;


class CocoonCollectionRdfMerger extends CocoonAbstractRdfMerger {

    protected function getTypeMergeMethodMap() {
        return [
            'http://www.europeana.eu/schemas/edm/Collection' => 'mergeEdmCollection',
            'http://www.europeana.eu/schemas/edm/Place' => 'mergeDcSpatialBlankNode'
        ];
    }

    protected function mergeEdmCollection($baseRes, $srcRes, $uri = null) {

        if(is_null($uri)) {
            $uri = $baseRes->getUri();
        }
        $targetArray =& $this->mergedArray[$uri];

        $this->mergeProperties([
            "http://purl.org/dc/terms/spatial"
        ], [
            "http://purl.org/dc/elements/1.1/title",
            "http://purl.org/dc/terms/available",
            "http://purl.org/dc/terms/created",
            "http://purl.org/dc/terms/issued",
            "http://purl.org/dc/terms/modified"
        ], $targetArray, $baseRes, $srcRes);

    }

    protected function mergeDcSpatialBlankNode($baseRes, $srcRes, $uri=null) {
        if(is_null($uri)) {
            $uri = $baseRes->getUri();
        }
        $targetArray =& $this->mergedArray[$uri];

        $this->mergeProperties([],[
            "http://www.w3.org/2003/01/geo/wgs84_pos#lat",
            "http://www.w3.org/2003/01/geo/wgs84_pos#long",
            "http://www.w3.org/2003/01/geo/wgs84_pos#alt",
            "http://www.w3.org/2002/07/owl#sameAs"
        ], $targetArray, $baseRes, $srcRes);
    }

}
