# App-client

This README outlines the details of collaborating on this Ember application.
A short introduction of this app could easily go here.

## Prerequisites

You will need the following things properly installed on your computer.

* [Node.js](http://nodejs.org/) (with NPM)
* [PhantomJS](http://phantomjs.org/)

## Installation

* `npm install`
* `bower install`

## Running / Development

* `npm start` (shortcut for `ember serve --environment=development` which serve the application)
* Visit your app at [http://localhost:4200](http://localhost:4200).

### Code Generators

Make use of the many generators for code, try `ember help generate` for more details

### Running Tests

* `ember test`
* `ember test --server`

## Build / Production

* `npm build` (shortcut for `ember build --environment=production` which serve the application)
* Visit /dist to check the built files

## Api configuration

* As Ember advices, all the logic of the api (host, namespace), is located in `adapters/application.js`.
* Two ways are provided:    
  * `Fixture`: deprecated in Ember and have been move out. We know use `ember-data-fixture-adapter` which provides the same behavior.
**However** it doesn't allow the use of `this.store.findRecord(...)` function. In our case it won't trigger the api request for the full document information (therefore doesn't get the sound urls). --> **Only use for testing**

  * `RESTAdapter`: The Common way of plugging in Ember with a Rest server.

## visualizations

### "Langues"

It use D3js and the implementation by [Mike Bostock](http://bost.ocks.org/mike/treemap/) customized to fit our needs.
The json used to build the treemap follows this example (can be find in `public/langues.json`):
```json
{
 "name": "Global",
 "children": [
  {
    "id": "id de langue (code Lexvo de la langues)",
    "name": "Français",
    "color": "lightblue",
    "value": 859
  },
  {
    "name": "Wallis et Futuna",
    "value": 43,
    "children": [
      {
        "name": "LanEast Futuna (fud)",
        "value": 23
      },
      {
        "name": "Wallisian (wls)",
        "value": 20
      }
    ]
  }
 ]
}
```
A `color` attribute can be add to each node.

### "Carthographie"

It use the [Ammap](https://www.amcharts.com/javascript-maps/) library.

It also uses a JSON to describe the areas. It is possible to get the bounding box of the country clicked, however it is a rectangle and isn't as precise as the SVG path.

It seems to use the `ISO 3166-1` country naming convention ("US", "FR", "BZ", etc.)
