import Ember from 'ember';

export default Ember.Component.extend({
  didInsertElement: function(){
    var data = google.visualization.arrayToDataTable([
      ['Location', 'Parent', 'Market trade volume (size)', 'Market increase/decrease (color)'],
      ['Global',    null,     0,    0],
      ['Français',	'Global',	859,	859],
      ['Alsacien',	'Global',	851,	851],
      ['Breton',    'Global',	403,	403],
      ['Occitan',	'Global',	344,	344],
      ['Judéo-espagnol',	'Global',	77,	77],
      ['Undetermined',	'Global',	45,	45],
      ['Langues régionales',	'Global',	175,	175],
      ['Langues non territoriales',	'Global',	48,	48],
      ['Les Creoles',	'Global',	47,	47],
      ['Guyane',	'Global',	59,	59],
      ['Mayotte',	'Global',	20,	20],
      ['Polynésie française',	'Global',	13,	13],
      ['Wallis et Futuna',	'Global',	43,	43],
      ['Nouvelle-Calédonie',	'Global',	68,	68],
      ['Langues d’oïl', 'Langues régionales',	75,	75],
      ['Francoprovençal',	'Langues régionales',	60,	60],
      ['Corse',	'Langues régionales',	40,	40],
      ['Langue des signes française (LSF)',	'Langues non territoriales',	40,	40],
      ['Berbère',	'Langues non territoriales',	8,	8],
      ['Creole de la Réunion',	'Les Creoles',	32,	32],
      ['Creole de la Guadeloupe',	'Les Creoles',	15,	15],
      ['Ndyuka-Trio Pidgin (njt)',	'Guyane',	31,	31],
      ['Palikúr (plu)', 'Guyane',	6,	6],
      ['Guianese Creole French (gcr)',	'Guyane',	4,	4],
      ['Eastern Maroon Creole (djk)',	'Guyane',	16,	16],
      ['Sranan Tongo (srn)',	'Guyane',	2,	2],
      ['Maore Comorian (swb)',	'Mayotte',	2, 2],
      ['Mauritian Sign Language (lsy)',	'Mayotte',	18,	18],
      ['West Uvean (uve)',	'Polynésie française',	13,	13],
      ['East Futuna (fud)',	'Wallis et Futuna',	23,	23],
      ['Wallisian (wls)',	'Wallis et Futuna',	20,	20],
      ['Nemi (nem)',	'Nouvelle-Calédonie',	15,	15],
      ['Xârâcùù (ane)',	'Nouvelle-Calédonie',	12,	12],
      ['Cemuhî (cam)',	'Nouvelle-Calédonie',	9,	9],
      ['Xaragure (axx)',	'Nouvelle-Calédonie',	9,	9],
      ['Iaai (iai)',	'Nouvelle-Calédonie',	8,	8],
      ['Nêlêmwa-Nixumwak (nee)',	'Nouvelle-Calédonie',	4,	4],
      ['Dehu (dhv)',	'Nouvelle-Calédonie',	2,	2],
      ['Nengone (nen)',	'Nouvelle-Calédonie',	2,	2],
      ['Ajië (aji)',	'Nouvelle-Calédonie',	1,	1],
      ['Numee (kdk)',	'Nouvelle-Calédonie',	1,	1],
      ['Yuaga (nua)',	'Nouvelle-Calédonie',	1,	1],
      ['Bwatoo (bwa)',	'Nouvelle-Calédonie',	4,	4]
    ]);





    var tree = new google.visualization.TreeMap(document.getElementById('chart_div'));

    tree.draw(data, {
      minColor: '#E0EEEF',
      midColor: '#7CACAE',
      maxColor: '#2D7073',
      headerHeight: 15,
      fontColor: 'black',
      showScale: true
    });
  }
});
