<?php
namespace CorpusParole\Models;

use CorpusParole\Libraries\RdfModel\RdfModelResource;
use JsonSerializable;
use Log;

/**
 * Model class for Document. Inherit from EasyRd\Resource
 * SELECT DISTINCT ?g WHERE {GRAPH ?g {?s ?p ?o}}
 */
abstract class WebResource extends RdfModelResource implements JsonSerializable {

    public function __construct(...$args) {
        list($uri, $graph) = $args;
        parent::__construct($uri, $graph);
    }

    private $format = -1;

    abstract protected function doClearMemoizationCache();

    public function clearMemoizationCache() {
        $this->format = -1;
        $this->doClearMemoizationCache();
    }

    public function getFormat() {
        if($this->format === -1) {
            $format = $this->getLiteral("<http://purl.org/dc/elements/1.1/format>");
            $this->format = is_null($format)?null:$format->getValue();
        }
        return $this->format;
    }

    public function getUrl() {
        return $this->getUri();
    }

    abstract protected function jsonSerializeExtra();

    public function jsonSerialize() {
        return array_merge(
            [
                'url' => $this->getUrl(),
                'format' => $this->getFormat()
            ],
            $this->jsonSerializeExtra()
        );
    }

}