<?php

namespace CorpusParole\Http\Controllers\Api;

// use CorpusParole\Http\Requests;
use Illuminate\Http\Request;
use Log;
use Es;

use CorpusParole\Libraries\Sparql\SparqlClient;

use CorpusParole\Http\Controllers\Controller;


class DateStatsController extends Controller
{
    private $sparqlClient = null;

    public function __construct(SparqlClient $sparqlClient) {
        $this->sparqlClient = $sparqlClient;
    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

        $query = [ "match_all" => []];

        $esQuery = [
            'index' => env('ELASTICSEARCH_INDEX'),
            'body' => [
                "size" => 0,
                "query" => $query,
                "aggs" => [
                    "datestats" => [
                        "nested"=> [
                            "path" => "creation_years"
                        ],
                        "aggs" => [
                            "years" => [
                                "terms"=> [
                                    "field" => "creation_years.year",
                                    "size" => 0,
                                    "order" => [
                                        "_term" => "asc"
                                    ]
                                ],
                                "aggs" => [
                                    "year_count" => [
                                        "sum" => [
                                            "field" => "creation_years.weight"
                                        ]
                                    ]
                                ]
                            ]
                        ]
                    ]
                ]
            ]
        ];
        $esRes = Es::search($esQuery);

        $datestats = [];

        foreach($esRes['aggregations']['datestats']['years']['buckets'] as $bucket) {
            $datestats[(string)($bucket['key'])] = round($bucket['year_count']['value']);
        }

        return response()->json(['datestats' => $datestats ]);
    }

}
