import Ember from 'ember';

export default Ember.Component.extend({

    classNames: ['color-gradient'],

    colors: Ember.inject.service(),

    domainStart: 0,
    domainEnd: 100,
    scale: null,

    scaleProxy: Ember.computed('scale', function() {
        let scaleRaw = this.get('scale');
        if(scaleRaw === null) {
            return this.get('colors').getScaleLinear(this.get('domainStart'), this.get('domainEnd'));
        } else {
            return scaleRaw;
        }
    }),

    domainMed: Ember.computed('domainStart', 'domainEnd', function() {
        return Math.round((this.get('domainEnd')+this.get('domainStart'))/2);
    }),

    colorList: Ember.computed('scale', function() {
        return this.get('scaleProxy').colors(100);
    })

});
