<?php

namespace CorpusParole\Http\Controllers\Api;

// use Illuminate\Http\Request;
// use CorpusParole\Http\Requests;
use CorpusParole\Http\Controllers\Controller;

use CorpusParole\Libraries\Sparql\SparqlClient;


class LanguageController extends Controller
{
    private $sparqlClient = null;

    public function __construct(SparqlClient $sparqlClient) {
        $this->sparqlClient = $sparqlClient;
    }

    /**
     * Display the specified resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

        $query = "select ?lang (count(?lang) as ?count) where {
            ?s a <http://www.europeana.eu/schemas/edm/ProvidedCHO>.
            ?s <http://purl.org/dc/elements/1.1/language> ?lang
        }
        GROUP BY ?lang
        ORDER BY DESC(?count)";

        $docs = $this->sparqlClient->query($query);

        $languages = [];
        foreach ($docs as $row) {
            $languages[$row->lang->getUri()] = $row->count->getValue();
        }

        return response()->json(['languages' => $languages ]);

    }

}
